/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EBusTypeFloat
extends EBusAbstractType<BigDecimal> {
    private static final Logger logger = LoggerFactory.getLogger(EBusTypeFloat.class);
    public static String TYPE_FLOAT = "float";
    private static String[] supportedTypes = new String[]{TYPE_FLOAT};

    @Override
    public byte[] getReplaceValue() {
        return new byte[]{127, -128, 0, 0};
    }

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return 4;
    }

    @Override
    public @Nullable BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        float value = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getFloat();
        if (!Float.isNaN(value)) {
            return BigDecimal.valueOf(value);
        }
        logger.trace("Raw float value {} is NaN!", (Object)EBusUtils.toHexDumpString(data));
        return null;
    }

    @Override
    public byte @Nullable [] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = NumberUtils.toBigDecimal(data == null ? Integer.valueOf(0) : data);
        if (b != null) {
            ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            return buffer.putFloat(b.floatValue()).array();
        }
        return null;
    }

    public String toString() {
        return "EBusTypeFloat [replaceValue=" + EBusUtils.toHexDumpString(this.getReplaceValue()).toString() + "]";
    }
}

