/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.std.AbstractEBusTypeNumber;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusTypeData2b
extends AbstractEBusTypeNumber {
    public static String TYPE_DATA2B = "data2b";
    private static String[] supportedTypes = new String[]{TYPE_DATA2B};

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return 2;
    }

    @Override
    public @Nullable BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        BigDecimal decodeInt = super.decodeInt(data);
        if (decodeInt != null) {
            return decodeInt.divide(BigDecimal.valueOf(256L));
        }
        return null;
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = NumberUtils.toBigDecimal(data);
        if (b == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        return super.encodeInt(b.multiply(BigDecimal.valueOf(256L)));
    }

    public String toString() {
        return "EBusTypeData2b [replaceValue=" + EBusUtils.toHexDumpString(this.getReplaceValue()).toString() + "]";
    }
}

