/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusTypeBCD
extends EBusAbstractType<BigDecimal> {
    public static String TYPE_BCD = "bcd";
    private static final String[] supportedTypes = new String[]{TYPE_BCD};
    private int length = 1;

    public EBusTypeBCD() {
        this.replaceValue = new byte[]{-1};
    }

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return this.length;
    }

    @Override
    public @Nullable BigDecimal decodeInt(byte @Nullable [] data) {
        Objects.requireNonNull(data);
        BigDecimal result = BigDecimal.valueOf(0L);
        for (int i = 0; i < data.length; ++i) {
            Byte convertBcd2Dec = NumberUtils.convertBcd2Dec(data[i]);
            if (convertBcd2Dec == null) {
                return null;
            }
            result = result.multiply(BigDecimal.valueOf(100L));
            result = result.add(BigDecimal.valueOf(convertBcd2Dec.byteValue()));
        }
        return result;
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal hundred = BigDecimal.valueOf(100L);
        byte[] result = new byte[this.getTypeLength()];
        BigDecimal b = NumberUtils.toBigDecimal(data);
        if (b == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        for (int i = 0; i < result.length; ++i) {
            BigDecimal[] divideAndRemainder = b.divideAndRemainder(hundred);
            b = divideAndRemainder[0];
            Byte bcd = NumberUtils.convertDec2Bcd(divideAndRemainder[1].byteValue());
            if (bcd == null) {
                throw new EBusTypeException("Unable to convert the byte value to BCD format!");
            }
            result[result.length - (i + 1)] = bcd;
        }
        return result;
    }

    public String toString() {
        return "EBusTypeBCD [replaceValue=" + EBusUtils.toHexDumpString(this.getReplaceValue()).toString() + ", length=" + this.length + "]";
    }
}

