/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public abstract class AbstractEBusTypeNumber
extends EBusAbstractType<BigDecimal> {
    @Override
    public byte[] getReplaceValue() {
        int length = this.getTypeLength();
        byte[] lReplacevalue = this.replaceValue;
        if (lReplacevalue == null || lReplacevalue.length == 0) {
            lReplacevalue = new byte[length];
            lReplacevalue[length - 1] = -128;
        }
        this.replaceValue = lReplacevalue;
        return lReplacevalue;
    }

    @Override
    public @Nullable BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        byte[] clone = ArrayUtils.clone((byte[])data);
        ArrayUtils.reverse((byte[])clone);
        return new BigDecimal(new BigInteger(clone));
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = NumberUtils.toBigDecimal(data == null ? Integer.valueOf(0) : data);
        if (b == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        long l = b.longValue();
        int length = this.getTypeLength();
        byte[] result = new byte[length];
        for (int i = 0; i <= length - 1; ++i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }
}

