/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.std.EBusTypeBCD;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusTypeVersion
extends EBusAbstractType<BigDecimal> {
    public static String TYPE_VERSION = "version";
    private static String[] supportedTypes = new String[]{TYPE_VERSION};

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return 2;
    }

    @Override
    public @Nullable BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        byte[] verData = new byte[]{data[0]};
        byte[] revData = new byte[]{data[1]};
        BigDecimal ver = (BigDecimal)this.types.decode(EBusTypeBCD.TYPE_BCD, verData);
        BigDecimal rev = (BigDecimal)this.types.decode(EBusTypeBCD.TYPE_BCD, revData);
        if (ver != null && rev != null) {
            BigDecimal fraction = rev.divide(BigDecimal.valueOf(100L));
            return ver.add(fraction);
        }
        return null;
    }

    @Override
    public byte @Nullable [] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal value = NumberUtils.toBigDecimal(data);
        if (value == null) {
            return this.applyByteOrder(this.getReplaceValue());
        }
        BigDecimal[] values = value.divideAndRemainder(BigDecimal.ONE);
        values[1] = values[1].multiply(BigDecimal.valueOf(100L));
        byte[] encode1 = this.types.encode(EBusTypeBCD.TYPE_BCD, values[0]);
        byte[] encode2 = this.types.encode(EBusTypeBCD.TYPE_BCD, values[1]);
        if (encode1 == null || encode1.length == 0 || encode2 == null || encode2.length == 0) {
            return null;
        }
        return new byte[]{encode1[0], encode2[0]};
    }

    public String toString() {
        return "EBusTypeVersion [length=2]";
    }
}

