/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusTypeString
extends EBusAbstractType<String> {
    public static String TYPE_STRING = "string";
    private static String[] supportedTypes = new String[]{TYPE_STRING};
    private Integer length = 1;

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public String decodeInt(byte @Nullable [] data) {
        return new String(data);
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) {
        if (data == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.length; ++i) {
                sb.append(' ');
            }
            return sb.toString().getBytes();
        }
        byte[] b = new byte[this.length.intValue()];
        System.arraycopy(data.toString().getBytes(), 0, b, 0, b.length);
        return b;
    }

    @Override
    public int getTypeLength() {
        return this.length;
    }

    public String toString() {
        return "EBusTypeString [length=" + this.length + "]";
    }
}

