/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.std.EBusTypeWord;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusTypeMultiWord
extends EBusAbstractType<BigDecimal> {
    public static String TYPE_MWORD = "mword";
    public static String BLOCK_MULTIPLIER = "multiplier";
    private static String[] supportedTypes = new String[]{TYPE_MWORD};
    private int length = 2;
    private BigDecimal multiplier = BigDecimal.valueOf(1000L);

    @Override
    public String @NonNull [] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return this.length * 2;
    }

    @Override
    public @Nullable BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        byte[] dataNew = new byte[2];
        int x = this.length - 1;
        BigDecimal valx = new BigDecimal(0);
        for (int i = 0; i <= x; ++i) {
            System.arraycopy(data, i * 2, dataNew, 0, dataNew.length);
            BigDecimal value = (BigDecimal)this.types.decode(EBusTypeWord.TYPE_WORD, dataNew);
            if (value == null) {
                throw new EBusTypeException("Unable to convert data to type WORD!");
            }
            BigDecimal factor = this.multiplier.pow(i);
            valx = valx.add(value.multiply(factor));
        }
        return valx;
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        int length;
        BigDecimal value = NumberUtils.toBigDecimal(data);
        if (value == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        byte[] result = new byte[this.getTypeLength()];
        for (int i = length = this.length - 1; i >= 0; --i) {
            BigDecimal factor = this.multiplier.pow(i);
            BigDecimal[] divideAndRemainder = value.divideAndRemainder(factor);
            byte[] encode = this.types.encode(EBusTypeWord.TYPE_WORD, divideAndRemainder[0]);
            value = divideAndRemainder[1];
            System.arraycopy(encode, 0, result, i * 2, 2);
        }
        return result;
    }

    public String toString() {
        return "EBusTypeMultiWord [length=" + this.length + ", multiplier=" + this.multiplier + ", replaceValue=" + EBusUtils.toHexDumpString(this.getReplaceValue()).toString() + "]";
    }
}

