/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes;

import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.EBusTypeRegistry;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.utils.EBusUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class EBusAbstractType<T>
implements IEBusType<T> {
    private static final Logger logger = LoggerFactory.getLogger(EBusAbstractType.class);
    protected Map<Object, @Nullable EBusAbstractType<T>> otherInstances = new HashMap<Object, EBusAbstractType<T>>();
    protected byte @Nullable [] replaceValue = null;
    protected boolean reverseByteOrder = false;
    protected EBusTypeRegistry types;

    protected byte @Nullable [] applyByteOrder(byte @Nullable [] data) {
        data = ArrayUtils.clone((byte[])data);
        if (this.reverseByteOrder) {
            ArrayUtils.reverse((byte[])data);
        }
        return data;
    }

    private @Nullable EBusAbstractType<T> createNewInstance() {
        try {
            EBusAbstractType newInstance = (EBusAbstractType)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (newInstance != null) {
                newInstance.setTypesParent(this.types);
                return newInstance;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("error!", (Throwable)e);
        }
        return null;
    }

    @Override
    public @Nullable T decode(byte @Nullable [] data) throws EBusTypeException {
        Objects.requireNonNull(data);
        if (data.length != this.getTypeLength()) {
            throw new EBusTypeException("Input parameter byte-array has size {0}, expected {1} for eBUS type {2}", data.length, this.getTypeLength(), this.getClass().getSimpleName());
        }
        if (this.equalsReplaceValue(data = this.applyByteOrder(data))) {
            return null;
        }
        return this.decodeInt(data);
    }

    public @Nullable T decodeInt(byte @Nullable [] data) throws EBusTypeException {
        throw new UnsupportedOperationException("Must be overwritten by superclass!");
    }

    @Override
    public byte[] encode(@Nullable Object data) throws EBusTypeException {
        if (data == null) {
            return this.applyByteOrder(this.getReplaceValue());
        }
        byte[] result = this.encodeInt(data);
        if ((result = this.applyByteOrder(result)).length != this.getTypeLength()) {
            throw new EBusTypeException("Result byte-array has size {0}, expected {1} for eBUS type {2}", result.length, this.getTypeLength(), this.getClass().getSimpleName());
        }
        return result;
    }

    public byte @Nullable [] encodeInt(@Nullable Object data) throws EBusTypeException {
        throw new UnsupportedOperationException("Must be overwritten by superclass!");
    }

    protected boolean equalsReplaceValue(byte @Nullable [] data) {
        return Objects.deepEquals(data, this.getReplaceValue());
    }

    @Override
    public @Nullable IEBusType<T> getInstance(@Nullable Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(properties);
        String instanceKey = sortedMap.toString();
        EBusAbstractType<T> instance = this.otherInstances.get(instanceKey);
        if (instance == null) {
            instance = this.createNewInstance();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setInstanceProperty(instance, entry.getKey(), entry.getValue());
            }
            this.otherInstances.put(instanceKey, instance);
        }
        return instance;
    }

    public byte @Nullable [] getReplaceValue() {
        int length = this.getTypeLength();
        byte[] repValue = this.replaceValue;
        if (repValue == null || repValue.length == 0) {
            repValue = new byte[length];
            Arrays.fill(repValue, (byte)-1);
            this.replaceValue = repValue;
        }
        return repValue;
    }

    @Override
    public int getTypeLength() {
        return 0;
    }

    protected void setInstanceProperty(@Nullable EBusAbstractType<T> instance, @Nullable String property, @Nullable Object value) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(instance);
        if (property.equals("replaceValue")) {
            if (value instanceof String) {
                try {
                    instance.setReplaceValue(EBusUtils.toByteArray((String)value));
                }
                catch (EBusTypeException e) {
                    logger.error("error!", (Throwable)e);
                }
            }
            return;
        }
        try {
            Field field = FieldUtils.getField(instance.getClass(), (String)property, (boolean)true);
            if (field != null) {
                field.set(instance, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            logger.error("error!", (Throwable)e);
        }
    }

    public void setReplaceValue(byte[] replaceValue) throws EBusTypeException {
        this.replaceValue = this.applyByteOrder(replaceValue);
    }

    @Override
    public void setTypesParent(EBusTypeRegistry types) {
        this.types = types;
    }
}

