/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command;

import de.csdev.ebus.command.EBusCommandMethod;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.IEBusValue;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.utils.CollectionUtils;
import de.csdev.ebus.utils.EBusUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EBusCommandValue
implements IEBusValue {
    private @Nullable Object defaultValue;
    private @Nullable BigDecimal factor;
    private @Nullable String format;
    private @Nullable String label;
    private @Nullable Map<String, String> mapping;
    private @Nullable BigDecimal max;
    private @Nullable BigDecimal min;
    private @Nullable String name;
    private EBusCommandMethod parent;
    private Map<String, Object> properties;
    private BigDecimal step;
    private IEBusType<?> type;

    public static EBusCommandValue getInstance(IEBusType<?> type, byte[] data) {
        EBusCommandValue value = new EBusCommandValue();
        value.setType(type);
        value.setDefaultValue(data);
        return value;
    }

    protected EBusCommandValue createInstance() {
        return new EBusCommandValue();
    }

    @Override
    public @NonNull EBusCommandValue getClonedInstance() {
        EBusCommandValue clone = this.createInstance();
        clone.defaultValue = this.defaultValue;
        clone.factor = this.factor;
        clone.format = this.format;
        clone.label = this.label;
        clone.max = this.max;
        clone.min = this.min;
        clone.name = this.name;
        clone.step = this.step;
        clone.type = this.type;
        if (this.mapping != null) {
            clone.mapping = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : this.mapping.entrySet()) {
                clone.mapping.put(entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.properties != null) {
            clone.properties = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                clone.properties.put(entry.getKey(), entry.getValue());
            }
        }
        return clone;
    }

    @Override
    public @Nullable Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public @Nullable BigDecimal getFactor() {
        return this.factor;
    }

    @Override
    public @Nullable String getFormat() {
        return this.format;
    }

    @Override
    public @Nullable String getLabel() {
        return this.label;
    }

    @Override
    public @Nullable Map<@NonNull String, @NonNull String> getMapping() {
        return this.mapping;
    }

    @Override
    public @Nullable BigDecimal getMax() {
        return this.max;
    }

    @Override
    public @Nullable BigDecimal getMin() {
        return this.min;
    }

    @Override
    public @Nullable String getName() {
        return this.name;
    }

    @Override
    public @Nullable IEBusCommandMethod getParent() {
        return this.parent;
    }

    @Override
    public @Nullable Map<@NonNull String, @NonNull Object> getProperties() {
        return CollectionUtils.unmodifiableNotNullMap(this.properties);
    }

    @Override
    public @Nullable BigDecimal getStep() {
        return this.step;
    }

    @Override
    public @NonNull IEBusType<?> getType() {
        return Objects.requireNonNull(this.type);
    }

    public void setDefaultValue(@Nullable Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFactor(@Nullable BigDecimal factor) {
        this.factor = factor;
    }

    public void setFormat(@Nullable String format) {
        this.format = format;
    }

    public void setLabel(@Nullable String label) {
        this.label = label;
    }

    public void setMapping(@Nullable Map<String, String> mapping) {
        this.mapping = mapping;
    }

    public void setMax(@Nullable BigDecimal max) {
        this.max = max;
    }

    public void setMin(@Nullable BigDecimal min) {
        this.min = min;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void setParent(@Nullable EBusCommandMethod parent) {
        this.parent = parent;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(properties);
    }

    public void setProperty(String key, String value) {
        this.properties = CollectionUtils.newMapIfNull(this.properties);
        this.properties.put(key, value);
    }

    public void setStep(@Nullable BigDecimal step) {
        this.step = step;
    }

    public void setType(@Nullable IEBusType<?> type) {
        this.type = type;
    }

    public String toString() {
        Object defaultValueMod = this.defaultValue instanceof byte[] ? EBusUtils.toHexDumpString((byte[])this.defaultValue) : this.defaultValue;
        return "EBusCommandValue [" + (this.name != null ? "name=" + this.name + ", " : "") + (this.label != null ? "label=" + this.label + ", " : "") + (this.type != null ? "type=" + this.type + ", " : "") + (this.min != null ? "min=" + this.min + ", " : "") + (this.max != null ? "max=" + this.max + ", " : "") + (this.factor != null ? "factor=" + this.factor + ", " : "") + (this.mapping != null ? "mapping=" + this.mapping + ", " : "") + (this.properties != null ? "properties=" + this.properties + ", " : "") + (this.step != null ? "step=" + this.step + ", " : "") + (this.format != null ? "format=" + this.format + ", " : "") + (defaultValueMod != null ? "defaultValue=" + defaultValueMod : "") + "]";
    }
}

