/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command;

import de.csdev.ebus.command.IEBusCommand;
import de.csdev.ebus.command.IEBusCommandCollection;
import de.csdev.ebus.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusCommandCollection
implements IEBusCommandCollection {
    private Map<String, IEBusCommand> commands = new HashMap<String, IEBusCommand>();
    private String description;
    private String id;
    private List<String> identification = new ArrayList<String>();
    private String label;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private byte[] sourceHash;

    public EBusCommandCollection(String id, String label, String description, Map<String, Object> properties) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(label);
        Objects.requireNonNull(description);
        Objects.requireNonNull(properties);
        this.id = id;
        this.label = label;
        this.description = description;
        this.properties.putAll(properties);
        this.sourceHash = new byte[0];
    }

    public void addCommand(IEBusCommand command) {
        this.commands.put(command.getId(), command);
    }

    public void addCommands(List<IEBusCommand> commands) {
        for (IEBusCommand command : commands) {
            this.addCommand(command);
        }
    }

    @Override
    public @NonNull Collection<IEBusCommand> getCommands() {
        Collection<IEBusCommand> collection = Collections.unmodifiableCollection(this.commands.values());
        return Objects.requireNonNull(collection);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public @NonNull String getId() {
        return Objects.requireNonNull(this.id);
    }

    @Override
    public @NonNull List<String> getIdentification() {
        return this.identification;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public @NonNull Map<String, Object> getProperties() {
        return Objects.requireNonNull(CollectionUtils.unmodifiableNotNullMap(this.properties));
    }

    @Override
    public @Nullable Object getProperty(String key) {
        return CollectionUtils.get(this.properties, key);
    }

    public void setIdentification(@Nullable List<String> identification) {
        if (identification != null && !identification.isEmpty()) {
            this.identification.clear();
            this.identification.addAll(identification);
        }
    }

    public void setSourceHash(byte[] sourceHash) {
        this.sourceHash = sourceHash;
    }

    public String toString() {
        return "EBusCommandCollection [commands=" + this.commands + ", properties=" + this.properties + ", id=" + this.id + ", label=" + this.label + ", identification=" + this.identification + "]";
    }

    @Override
    public @Nullable IEBusCommand getCommand(String id) {
        return this.commands.get(id);
    }

    @Override
    public byte[] getSourceHash() {
        return this.sourceHash;
    }
}

