/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command;

import de.csdev.ebus.command.IEBusCommand;
import de.csdev.ebus.command.IEBusCommandCollection;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.utils.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusCommand
implements IEBusCommand {
    private Map<IEBusCommandMethod.Method, IEBusCommandMethod> channels = new EnumMap<IEBusCommandMethod.Method, IEBusCommandMethod>(IEBusCommandMethod.Method.class);
    private @Nullable String configurationSource;
    private @Nullable String device;
    private @Nullable String id;
    private @Nullable String label;
    private @Nullable IEBusCommandCollection parentCollection;
    private @Nullable Map<String, Object> properties;

    public void addCommandChannel(IEBusCommandMethod channel) {
        Objects.requireNonNull(channel);
        this.channels.put(channel.getMethod(), channel);
    }

    @Override
    public Collection<IEBusCommandMethod.Method> getCommandChannelMethods() {
        return Objects.requireNonNull(Collections.unmodifiableCollection(this.channels.keySet()));
    }

    @Override
    public @Nullable IEBusCommandMethod getCommandMethod(IEBusCommandMethod.Method channel) {
        Objects.requireNonNull(channel);
        return CollectionUtils.get(this.channels, channel);
    }

    @Override
    public @NonNull Collection<IEBusCommandMethod> getCommandMethods() {
        return Objects.requireNonNull(Collections.unmodifiableCollection(this.channels.values()));
    }

    @Override
    public @Nullable String getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public @Nullable String getDevice() {
        return this.device;
    }

    @Override
    public String getId() {
        return Objects.requireNonNull(this.id);
    }

    @Override
    public @Nullable String getLabel() {
        return this.label;
    }

    @Override
    public IEBusCommandCollection getParentCollection() {
        return Objects.requireNonNull(this.parentCollection);
    }

    @Override
    public Map<String, Object> getProperties() {
        return Objects.requireNonNull(CollectionUtils.unmodifiableNotNullMap(this.properties));
    }

    public void setConfigurationSource(@Nullable String configurationSource) {
        this.configurationSource = configurationSource;
    }

    public void setDevice(@Nullable String device) {
        this.device = device;
    }

    public EBusCommand setId(String id) {
        Objects.requireNonNull(id, "id");
        this.id = id;
        return this;
    }

    public void setLabel(@Nullable String label) {
        this.label = label;
    }

    public void setParentCollection(IEBusCommandCollection parentCollection) {
        Objects.requireNonNull(parentCollection, "parentCollection");
        this.parentCollection = parentCollection;
    }

    public void setProperties(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "properties");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(properties);
        this.properties = props;
    }

    public void setProperty(String key, String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        Map<String, Object> propertiesx = this.properties = CollectionUtils.newMapIfNull(this.properties);
        if (propertiesx != null) {
            propertiesx.put(key, value);
        }
    }

    public String toString() {
        return "EBusCommand [configurationSource=" + this.configurationSource + ", label=" + this.label + ", device=" + this.device + ", id=" + this.id + ", properties=" + this.properties + ", channels=" + this.channels + "]";
    }
}

