/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.client;

import de.csdev.ebus.command.EBusCommandException;
import de.csdev.ebus.command.EBusCommandRegistry;
import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.command.IEBusCommandCollection;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.core.EBusControllerException;
import de.csdev.ebus.core.IEBusConnectorEventListener;
import de.csdev.ebus.core.IEBusController;
import de.csdev.ebus.service.device.EBusDeviceTable;
import de.csdev.ebus.service.device.EBusDeviceTableService;
import de.csdev.ebus.service.device.IEBusDeviceTableListener;
import de.csdev.ebus.service.metrics.EBusMetricsService;
import de.csdev.ebus.service.parser.EBusParserService;
import de.csdev.ebus.service.parser.IEBusParserListener;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EBusClient {
    private static final String LABEL_LISTENER = "listener";
    private @NonNull EBusCommandRegistry commandRegistry;
    private @Nullable IEBusController controller;
    private @NonNull EBusDeviceTable deviceTable;
    private @Nullable EBusDeviceTableService deviceTableService;
    private @NonNull EBusMetricsService metricsService;
    private @NonNull EBusParserService resolverService;

    public EBusClient(@NonNull EBusCommandRegistry commandRegistry) {
        Objects.requireNonNull(commandRegistry);
        this.commandRegistry = commandRegistry;
        this.resolverService = new EBusParserService(commandRegistry);
        this.metricsService = new EBusMetricsService();
        this.deviceTable = new EBusDeviceTable();
    }

    public void addEBusDeviceTableListener(@NonNull IEBusDeviceTableListener listener) {
        Objects.requireNonNull(listener, LABEL_LISTENER);
        this.deviceTable.addEBusDeviceTableListener(listener);
    }

    public void addEBusEventListener(@NonNull IEBusConnectorEventListener listener) {
        Objects.requireNonNull(listener, LABEL_LISTENER);
        IEBusController ctrl = this.controller;
        if (ctrl == null) {
            throw new IllegalStateException("Controller is not initialized!");
        }
        ctrl.addEBusEventListener(listener);
    }

    public void addEBusParserListener(@NonNull IEBusParserListener listener) {
        Objects.requireNonNull(listener, LABEL_LISTENER);
        this.resolverService.addEBusParserListener(listener);
    }

    public @NonNull Integer addToSendQueue(byte @NonNull [] buffer) throws EBusControllerException {
        Objects.requireNonNull(buffer, "buffer");
        IEBusController ctrl = this.controller;
        if (ctrl == null) {
            throw new EBusControllerException("Controller not set!");
        }
        return ctrl.addToSendQueue(buffer);
    }

    public @NonNull Integer addToSendQueue(byte @NonNull [] buffer, int maxAttemps) throws EBusControllerException {
        IEBusController ctrl = this.controller;
        if (ctrl == null) {
            throw new EBusControllerException("Controller not set!");
        }
        return ctrl.addToSendQueue(buffer, maxAttemps);
    }

    public @NonNull ByteBuffer buildTelegram(@NonNull IEBusCommandMethod commandMethod, @NonNull Byte destinationAddress, @Nullable Map<String, Object> values) throws EBusTypeException, EBusCommandException {
        Objects.requireNonNull(commandMethod, "commandMethod");
        Objects.requireNonNull(destinationAddress, "destinationAddress");
        byte masterAddress = this.getDeviceTable().getOwnDevice().getMasterAddress();
        return EBusCommandUtils.buildMasterTelegram(commandMethod, masterAddress, destinationAddress, values);
    }

    public void connect(@NonNull IEBusController controller, byte masterAddress) {
        Objects.requireNonNull(controller, "controller");
        controller.addEBusEventListener(this.resolverService);
        this.deviceTable.setOwnAddress(masterAddress);
        EBusDeviceTableService lDeviceTableService = new EBusDeviceTableService(controller, this.commandRegistry, this.deviceTable);
        this.resolverService.addEBusParserListener(lDeviceTableService);
        this.deviceTable.addEBusDeviceTableListener(lDeviceTableService);
        controller.addEBusEventListener(this.metricsService);
        this.resolverService.addEBusParserListener(this.metricsService);
        this.controller = controller;
        this.deviceTableService = lDeviceTableService;
    }

    public void dispose() {
        EBusDeviceTableService lDeviceTableService;
        IEBusController ctrl = this.controller;
        if (ctrl != null) {
            ctrl.interrupt();
            this.controller = null;
        }
        if ((lDeviceTableService = this.deviceTableService) != null) {
            lDeviceTableService.dispose();
            this.deviceTableService = null;
        }
        if (this.deviceTable != null) {
            this.deviceTable.dispose();
        }
        if (this.resolverService != null) {
            this.resolverService.dispose();
        }
    }

    public @Nullable IEBusCommandCollection getCommandCollection(@NonNull String id) {
        Objects.requireNonNull(id);
        return this.getConfigurationProvider().getCommandCollection(id);
    }

    public @NonNull Collection<@NonNull IEBusCommandCollection> getCommandCollections() {
        return this.getConfigurationProvider().getCommandCollections();
    }

    public @NonNull EBusCommandRegistry getConfigurationProvider() {
        return this.commandRegistry;
    }

    public @Nullable IEBusController getController() {
        return this.controller;
    }

    public @NonNull EBusDeviceTable getDeviceTable() {
        return this.deviceTable;
    }

    public @Nullable EBusDeviceTableService getDeviceTableService() {
        return this.deviceTableService;
    }

    public @NonNull EBusMetricsService getMetricsService() {
        return this.metricsService;
    }

    public @NonNull EBusParserService getResolverService() {
        return this.resolverService;
    }

    public boolean removeEBusDeviceTableListener(@NonNull IEBusDeviceTableListener listener) {
        Objects.requireNonNull(listener);
        return this.getDeviceTable().removeEBusDeviceTableListener(listener);
    }

    public boolean removeEBusEventListener(@NonNull IEBusConnectorEventListener listener) {
        Objects.requireNonNull(listener);
        IEBusController ctrl = this.controller;
        if (ctrl != null) {
            return ctrl.removeEBusEventListener(listener);
        }
        return false;
    }

    public boolean removeEBusParserListener(@NonNull IEBusParserListener listener) {
        Objects.requireNonNull(listener);
        return this.getResolverService().removeEBusParserListener(listener);
    }
}

