/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.cfg.std;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.csdev.ebus.cfg.EBusConfigurationReaderException;
import de.csdev.ebus.cfg.IEBusConfigurationReader;
import de.csdev.ebus.cfg.std.EBusValueJsonDeserializer;
import de.csdev.ebus.cfg.std.dto.EBusCollectionDTO;
import de.csdev.ebus.cfg.std.dto.EBusCommandDTO;
import de.csdev.ebus.cfg.std.dto.EBusCommandMethodDTO;
import de.csdev.ebus.cfg.std.dto.EBusCommandTemplatesDTO;
import de.csdev.ebus.cfg.std.dto.EBusValueDTO;
import de.csdev.ebus.command.EBusCommand;
import de.csdev.ebus.command.EBusCommandCollection;
import de.csdev.ebus.command.EBusCommandMethod;
import de.csdev.ebus.command.EBusCommandNestedValue;
import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.command.EBusCommandValue;
import de.csdev.ebus.command.IEBusCommandCollection;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.EBusTypeRegistry;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.command.datatypes.ext.EBusTypeBytes;
import de.csdev.ebus.command.datatypes.std.EBusTypeByte;
import de.csdev.ebus.utils.EBusUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusConfigurationReader
implements IEBusConfigurationReader {
    private final Logger logger = LoggerFactory.getLogger(EBusConfigurationReader.class);
    private @NonNull EBusTypeRegistry registry;
    private @NonNull Map<@NonNull String, @Nullable Collection<@NonNull EBusCommandValue>> templateValueRegistry = new HashMap<String, Collection<EBusCommandValue>>();
    private @NonNull Map<@NonNull String, @Nullable Collection<@NonNull EBusCommandValue>> templateBlockRegistry = new HashMap<String, Collection<EBusCommandValue>>();

    public EBusConfigurationReader() {
        try {
            this.registry = new EBusTypeRegistry();
        }
        catch (EBusTypeException e) {
            throw new IllegalStateException("Unable to create a new eBus type registry!");
        }
    }

    @Override
    public @NonNull List<@NonNull IEBusCommandCollection> loadBuildInConfigurationCollections() throws EBusConfigurationReaderException, IOException {
        URL url = EBusConfigurationReader.class.getResource("/index-configuration.json");
        Objects.requireNonNull(url);
        return this.loadConfigurationCollectionBundle(url);
    }

    @Override
    public @NonNull IEBusCommandCollection loadConfigurationCollection(@NonNull URL url) throws IOException, EBusConfigurationReaderException {
        Objects.requireNonNull(url, "url");
        Type merchantListType = new TypeToken<List<EBusValueDTO>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(merchantListType, (Object)new EBusValueJsonDeserializer()).create();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        DigestInputStream dis = new DigestInputStream(url.openStream(), md);
        EBusCollectionDTO collection = Objects.requireNonNull((EBusCollectionDTO)gson.fromJson((Reader)new InputStreamReader(dis), EBusCollectionDTO.class));
        try {
            EBusCommandCollection commandCollection = (EBusCommandCollection)this.loadConfigurationCollection(collection);
            commandCollection.setSourceHash(md.digest());
            return commandCollection;
        }
        catch (EBusConfigurationReaderException e) {
            throw new EBusConfigurationReaderException("%s [ URL: %s ]", e.getMessage(), url);
        }
    }

    public @NonNull IEBusCommandCollection loadConfigurationCollection(@NonNull EBusCollectionDTO collection) throws EBusConfigurationReaderException {
        Objects.requireNonNull(collection, "collection");
        if (StringUtils.isEmpty((CharSequence)collection.getId())) {
            throw new EBusConfigurationReaderException("The property 'id' is missing for the configuration!");
        }
        if (StringUtils.isEmpty((CharSequence)collection.getLabel())) {
            throw new EBusConfigurationReaderException("The property 'label' is missing for the configuration!");
        }
        if (StringUtils.isEmpty((CharSequence)collection.getDescription())) {
            throw new EBusConfigurationReaderException("The property 'description' is missing for the configuration!");
        }
        if (collection.getProperties() == null) {
            throw new EBusConfigurationReaderException("The property 'properties' is missing for the configuration!");
        }
        EBusCommandCollection commandCollection = new EBusCommandCollection(collection.getId(), collection.getLabel(), collection.getDescription(), collection.getProperties());
        commandCollection.setIdentification(collection.getIdentification());
        this.parseTemplateListConfiguration(collection);
        List<EBusCommandDTO> commands = collection.getCommands();
        if (commands != null) {
            for (EBusCommandDTO commandDto : commands) {
                if (commandDto == null) continue;
                commandCollection.addCommand(this.parseTelegramConfiguration(commandCollection, commandDto));
            }
        }
        return commandCollection;
    }

    protected void parseTemplateListConfiguration(@NonNull EBusCollectionDTO collection) throws EBusConfigurationReaderException {
        Objects.requireNonNull(collection, "collection");
        List<EBusCommandTemplatesDTO> templateSection = collection.getTemplates();
        if (templateSection != null) {
            for (EBusCommandTemplatesDTO templates : templateSection) {
                this.parseTemplateBlockConfiguration(templates.getTemplate(), collection, templates);
            }
        }
    }

    protected void parseTemplateBlockConfiguration(@Nullable List<EBusValueDTO> templateValues, @NonNull EBusCollectionDTO collection, @NonNull EBusCommandTemplatesDTO templates) throws EBusConfigurationReaderException {
        if (templateValues == null) {
            return;
        }
        ArrayList<EBusCommandValue> blockList = new ArrayList<EBusCommandValue>();
        for (EBusValueDTO value : templateValues) {
            Collection<EBusCommandValue> pv;
            if (value == null || (pv = this.parseValueConfiguration(value, null, null, null)).isEmpty()) continue;
            blockList.addAll(pv);
            String id = collection.getId() + "." + templates.getName() + "." + value.getName();
            this.logger.trace("Add template with global id {} to registry ...", (Object)id);
            this.templateValueRegistry.put(id, pv);
        }
        if (!blockList.isEmpty()) {
            String id = collection.getId() + "." + templates.getName();
            this.logger.trace("Add template block with global id {} to registry ...", (Object)id);
            this.templateBlockRegistry.put(id, blockList);
        }
    }

    protected EBusCommand parseTelegramConfiguration(@NonNull IEBusCommandCollection commandCollection, @NonNull EBusCommandDTO commandElement) throws EBusConfigurationReaderException {
        Objects.requireNonNull(commandCollection, "commandCollection");
        LinkedHashMap<String, EBusCommandValue> templateMap = new LinkedHashMap<String, EBusCommandValue>();
        ArrayList<EBusCommandValue> templateList = new ArrayList<EBusCommandValue>();
        ArrayList<String> methods = new ArrayList<String>();
        if (commandElement.getGet() != null) {
            methods.add("get");
        }
        if (commandElement.getSet() != null) {
            methods.add("set");
        }
        if (commandElement.getBroadcast() != null) {
            methods.add("broadcast");
        }
        String id = commandElement.getId();
        byte[] command = EBusUtils.toByteArray(commandElement.getCommand());
        String label = commandElement.getLabel();
        String device = commandElement.getDevice();
        Byte destination = EBusUtils.toByte(commandElement.getDst());
        Byte source = EBusUtils.toByte(commandElement.getSrc());
        for (EBusValueDTO template : this.checkedList(commandElement.getTemplate())) {
            for (EBusCommandValue templateCfg : this.parseValueConfiguration(template, null, null, null)) {
                if (StringUtils.isEmpty((CharSequence)templateCfg.getName())) {
                    templateMap.put(templateCfg.getName(), templateCfg);
                }
                templateList.add(templateCfg);
            }
        }
        if (id == null) {
            throw new EBusConfigurationReaderException("Property 'id' is missing for command ! %s", commandElement != null ? commandElement.toString() : "<NULL>");
        }
        EBusCommand cfg = new EBusCommand();
        cfg.setId(id);
        cfg.setLabel(label);
        cfg.setDevice(device);
        cfg.setParentCollection(commandCollection);
        for (String channel : methods) {
            EBusCommandMethodDTO commandMethodElement = null;
            IEBusCommandMethod.Method method = null;
            if (channel.equals("get")) {
                commandMethodElement = commandElement.getGet();
                method = IEBusCommandMethod.Method.GET;
            } else if (channel.equals("set")) {
                commandMethodElement = commandElement.getSet();
                method = IEBusCommandMethod.Method.SET;
            } else if (channel.equals("broadcast")) {
                commandMethodElement = commandElement.getBroadcast();
                method = IEBusCommandMethod.Method.BROADCAST;
            }
            if (commandMethodElement == null) continue;
            EBusCommandMethod commandMethod = new EBusCommandMethod(cfg, method);
            if (StringUtils.isNotEmpty((CharSequence)commandMethodElement.getCommand())) {
                commandMethod.setCommand(EBusUtils.toByteArray(commandMethodElement.getCommand()));
            } else {
                commandMethod.setCommand(command);
            }
            commandMethod.setDestinationAddress(destination);
            commandMethod.setSourceAddress(source);
            for (EBusValueDTO template : this.checkedList(commandMethodElement.getMaster())) {
                for (EBusCommandValue ev : this.parseValueConfiguration(template, templateMap, templateList, commandMethod)) {
                    commandMethod.addMasterValue(ev);
                }
            }
            for (EBusValueDTO template : this.checkedList(commandMethodElement.getSlave())) {
                for (EBusCommandValue ev : this.parseValueConfiguration(template, templateMap, templateList, commandMethod)) {
                    commandMethod.addSlaveValue(ev);
                }
            }
            if (StringUtils.equals((CharSequence)commandMethodElement.getType(), (CharSequence)"master-master")) {
                commandMethod.setType(IEBusCommandMethod.Type.MASTER_MASTER);
            } else if (method == IEBusCommandMethod.Method.BROADCAST) {
                commandMethod.setDestinationAddress((byte)-2);
                commandMethod.setType(IEBusCommandMethod.Type.BROADCAST);
            } else {
                commandMethod.setType(IEBusCommandMethod.Type.MASTER_SLAVE);
            }
            if (commandMethod.getType() != IEBusCommandMethod.Type.MASTER_SLAVE || commandMethod.getSlaveTypes() != null) continue;
            this.logger.debug("Warning: Master-Slave command \"{}\" has no slave configuration defined!", (Object)EBusCommandUtils.getFullId(commandMethod));
        }
        return cfg;
    }

    protected @NonNull List<@NonNull EBusValueDTO> checkedList(List<EBusValueDTO> master) {
        ArrayList<@NonNull EBusValueDTO> templates = new ArrayList<EBusValueDTO>();
        if (master != null) {
            for (EBusValueDTO template : master) {
                if (template == null) continue;
                templates.add(template);
            }
        }
        return templates;
    }

    protected @NonNull Collection<@NonNull EBusCommandValue> parseValueConfiguration(@NonNull EBusValueDTO valueDto, @Nullable Map<@NonNull String, @NonNull EBusCommandValue> templateMap, @Nullable List<@NonNull EBusCommandValue> templateList, @Nullable EBusCommandMethod commandMethod) throws EBusConfigurationReaderException {
        Objects.requireNonNull(valueDto, "valueDto");
        ArrayList<@NonNull EBusCommandValue> result = new ArrayList<EBusCommandValue>();
        String typeStr = valueDto.getType();
        String collectionId = null;
        if (commandMethod != null && commandMethod.getParent() != null && commandMethod.getParent().getParentCollection() != null) {
            collectionId = commandMethod.getParent().getParentCollection().getId();
        }
        if (StringUtils.isEmpty((CharSequence)typeStr)) {
            throw new EBusConfigurationReaderException("Property 'type' is missing for command ! %s", commandMethod != null ? commandMethod.getParent() : "<NULL>");
        }
        if (typeStr != null && typeStr.equals("template-block")) {
            Collection<EBusCommandValue> templateCollection = null;
            if (StringUtils.isNotEmpty((CharSequence)valueDto.getName())) {
                this.logger.warn("Property 'name' is not allowed for type 'template-block', ignore property !");
            }
            String id = (String)valueDto.getProperty("id");
            String globalId = collectionId + "." + id;
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                templateCollection = this.templateBlockRegistry.get(id);
                if (templateCollection == null) {
                    this.logger.trace("Unable to find a template with id {}, second try with {} ...", (Object)id, (Object)globalId);
                    templateCollection = this.templateBlockRegistry.get(globalId);
                    if (templateCollection == null) {
                        throw new EBusConfigurationReaderException("Unable to find a template-block with id %s!", id);
                    }
                }
            } else if (templateMap != null) {
                templateCollection = new ArrayList<EBusCommandValue>(templateList);
            } else {
                throw new EBusConfigurationReaderException("No additional information for type 'template-block' defined!");
            }
            if (templateCollection != null) {
                for (EBusCommandValue commandValue : templateCollection) {
                    EBusCommandValue clone = commandValue.getClonedInstance();
                    clone.setParent(commandMethod);
                    this.overwritePropertiesFromTemplate(clone, valueDto);
                    result.add(clone);
                }
            }
            return result;
        }
        if (typeStr != null && typeStr.equals("template")) {
            String id = (String)valueDto.getProperty("id");
            String globalId = collectionId != null ? collectionId + "." + id : null;
            Collection<EBusCommandValue> templateCollection = null;
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new EBusConfigurationReaderException("No additional information for type 'template' defined!");
            }
            if (this.templateValueRegistry.containsKey(id)) {
                templateCollection = this.templateValueRegistry.get(id);
            } else if (globalId != null && this.templateValueRegistry.containsKey(globalId)) {
                templateCollection = this.templateValueRegistry.get(globalId);
            } else if (templateMap != null && templateMap.containsKey(id)) {
                templateCollection = new ArrayList<EBusCommandValue>();
                templateCollection.add(templateMap.get(id));
            } else {
                throw new EBusConfigurationReaderException("Unable to find a template for id %s!", id);
            }
            if (templateCollection != null && !templateCollection.isEmpty()) {
                for (EBusCommandValue commandValue : templateCollection) {
                    EBusCommandValue clone = commandValue.getClonedInstance();
                    clone.setParent(commandMethod);
                    this.overwritePropertiesFromTemplate(clone, valueDto);
                    clone.setName((String)StringUtils.defaultIfEmpty((CharSequence)valueDto.getName(), (CharSequence)clone.getName()));
                    result.add(clone);
                }
            } else {
                throw new EBusConfigurationReaderException("Internal template collection is empty!");
            }
            return result;
        }
        if (typeStr != null && typeStr.equals("static")) {
            byte[] byteArray = EBusUtils.toByteArray(valueDto.getDefault());
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("length", byteArray.length);
            IEBusType typeByte = this.registry.getType(EBusTypeBytes.TYPE_BYTES, properties);
            EBusCommandValue commandValue = EBusCommandValue.getInstance(typeByte, byteArray);
            commandValue.setParent(commandMethod);
            result.add(commandValue);
            return result;
        }
        EBusCommandValue ev = null;
        if (valueDto.getChildren() != null) {
            EBusCommandNestedValue evc = new EBusCommandNestedValue();
            IEBusType typeByte = this.registry.getType(EBusTypeByte.TYPE_BYTE);
            evc.setDefaultValue((byte)-1);
            evc.setType(typeByte);
            ev = evc;
            int pos = 0;
            List<EBusValueDTO> children = valueDto.getChildren();
            if (children != null) {
                for (EBusValueDTO childElem : children) {
                    childElem.setPos(pos);
                    for (EBusCommandValue childValue : this.parseValueConfiguration(childElem, templateMap, templateList, commandMethod)) {
                        evc.add(childValue);
                    }
                    ++pos;
                }
            }
        } else {
            ev = new EBusCommandValue();
        }
        Map<String, Object> map = valueDto.getAsMap();
        IEBusType type = this.registry.getType(typeStr, map);
        ev.setType(type);
        ev.setName(valueDto.getName());
        ev.setLabel(valueDto.getLabel());
        ev.setFactor(valueDto.getFactor());
        ev.setMin(valueDto.getMin());
        ev.setMax(valueDto.getMax());
        ev.setMapping(valueDto.getMapping());
        ev.setFormat(valueDto.getFormat());
        if (commandMethod != null) {
            ev.setParent(commandMethod);
        }
        result.add(ev);
        return result;
    }

    private void overwritePropertiesFromTemplate(@NonNull EBusCommandValue clone, @NonNull EBusValueDTO template) {
        String templateLabel = template.getLabel();
        String cloneLabel = clone.getLabel();
        if (StringUtils.isNotEmpty((CharSequence)templateLabel)) {
            if (StringUtils.isNotEmpty((CharSequence)cloneLabel) && cloneLabel.contains("%s")) {
                clone.setLabel(String.format(cloneLabel, templateLabel));
            } else {
                clone.setLabel(templateLabel);
            }
        }
    }

    @Override
    public void setEBusTypes(@NonNull EBusTypeRegistry ebusTypes) {
        Objects.requireNonNull(ebusTypes, "ebusTypes");
        this.registry = ebusTypes;
    }

    @Override
    public @NonNull List<@NonNull IEBusCommandCollection> loadConfigurationCollectionBundle(@NonNull URL url) throws EBusConfigurationReaderException, IOException {
        List files;
        Objects.requireNonNull(url, "url");
        ArrayList<@NonNull IEBusCommandCollection> result = new ArrayList<IEBusCommandCollection>();
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, ?>>(){}.getType();
        Map mapping = (Map)gson.fromJson((Reader)new InputStreamReader(url.openStream()), type);
        if (mapping.containsKey("files") && (files = (List)mapping.get("files")) != null && !files.isEmpty()) {
            for (Map file : files) {
                URL fileUrl = new URL(url, (String)file.get("url"));
                this.logger.debug("Load configuration from url {} ...", (Object)fileUrl);
                IEBusCommandCollection collection = this.loadConfigurationCollection(fileUrl);
                result.add(collection);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.templateBlockRegistry.clear();
        this.templateValueRegistry.clear();
    }

    public @NonNull Map<@NonNull String, @Nullable Collection<@NonNull EBusCommandValue>> getTemplateValueRegistry() {
        return this.templateValueRegistry;
    }

    public @NonNull Map<@NonNull String, @Nullable Collection<@NonNull EBusCommandValue>> getTemplateBlockRegistry() {
        return this.templateBlockRegistry;
    }
}

