/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import de.csdev.ebus.core.EBusWorkerThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emulator {
    private final Logger logger = LoggerFactory.getLogger(Emulator.class);
    private PipedInputStream in;
    private PipedOutputStream out;
    private ExecutorService pipeThreadExecutor;
    private ScheduledExecutorService playThreadExecutor;
    private Future<?> autoSyncFuture = null;
    private int factor = 10;

    private void stopAutoSync() {
        if (this.autoSyncFuture != null) {
            this.autoSyncFuture.cancel(true);
            this.autoSyncFuture = null;
        }
    }

    private void startAutoSync() {
        this.autoSyncFuture = this.playThreadExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                Emulator.this.write((byte)-86);
            }
        }, (long)(40 * this.factor), TimeUnit.MILLISECONDS);
    }

    public Emulator() {
        this(1, true);
    }

    public Emulator(int factor, boolean autoSync) {
        this.factor = factor;
        this.pipeThreadExecutor = Executors.newSingleThreadExecutor(new EBusWorkerThreadFactory("ebus-emu-pipe", false));
        this.playThreadExecutor = Executors.newScheduledThreadPool(1, new EBusWorkerThreadFactory("ebus-emu-play", false));
        if (autoSync) {
            this.startAutoSync();
        }
        try {
            this.in = new PipedInputStream();
            this.out = new PipedOutputStream(this.in);
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void write(final byte b) {
        this.pipeThreadExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PipedOutputStream pipedOutputStream = Emulator.this.out;
                    synchronized (pipedOutputStream) {
                        Emulator.this.stopAutoSync();
                        Emulator.this.out.write(b);
                        Emulator.this.out.flush();
                        try {
                            Thread.sleep(4 * Emulator.this.factor);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Emulator.this.startAutoSync();
                    }
                }
                catch (IOException e) {
                    Emulator.this.logger.trace("error!", (Throwable)e);
                }
            }
        });
    }

    public void write(final byte[] byteArray) {
        this.pipeThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (byte b : byteArray) {
                    Emulator.this.write(b);
                }
            }
        });
    }

    public void close() {
        if (this.autoSyncFuture != null) {
            this.autoSyncFuture.cancel(false);
        }
        this.playThreadExecutor.shutdownNow();
        this.pipeThreadExecutor.shutdownNow();
        try {
            this.playThreadExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.trace("error!", (Throwable)e);
        }
        try {
            this.pipeThreadExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.trace("error!", (Throwable)e);
        }
        IOUtils.closeQuietly((InputStream)this.in);
        IOUtils.closeQuietly((OutputStream)this.out);
    }
}

