/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.service.parser.IEBusParserListener;
import de.csdev.ebus.utils.EBusUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusTelegramWriter
implements IEBusParserListener {
    private final Logger logger = LoggerFactory.getLogger(EBusTelegramWriter.class);
    private BufferedWriter writerResolved;
    private BufferedWriter writerUnresolved;
    private File loggingDirectory;

    public EBusTelegramWriter(File loggingDirectory) {
        this.loggingDirectory = loggingDirectory;
    }

    @Override
    public void onTelegramResolved(@NonNull IEBusCommandMethod commandChannel, @NonNull Map<@NonNull String, @NonNull Object> result, byte @NonNull [] receivedData, @Nullable Integer sendQueueId) {
        try {
            if (this.writerResolved == null) {
                this.writerResolved = this.open("ebus-resolved.csv");
            }
            String comment = String.format("%s > %s.%s", new Object[]{commandChannel.getMethod(), commandChannel.getParent().getParentCollection().getId(), commandChannel.getParent().getId()});
            this.write(this.writerResolved, receivedData, comment);
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    @Override
    public void onTelegramResolveFailed(@Nullable IEBusCommandMethod commandChannel, byte @Nullable [] receivedData, @Nullable Integer sendQueueId, @Nullable String exceptionMessage) {
        try {
            if (this.writerUnresolved == null) {
                this.writerUnresolved = this.open("ebus-unresolved.csv");
            }
            this.write(this.writerUnresolved, receivedData, "");
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    private BufferedWriter open(String filename) throws IOException {
        File file = new File(this.loggingDirectory, filename);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        if (!file.exists()) {
            file.createNewFile();
        }
        this.logger.warn(file.getAbsolutePath());
        writer.write("Date/Time;");
        writer.write("SRC;");
        writer.write("DST;");
        writer.write("CMD;");
        writer.write("REMAIN_DATA;");
        writer.newLine();
        writer.flush();
        return writer;
    }

    public void close() {
        try {
            if (this.writerResolved != null) {
                this.writerResolved.flush();
                this.writerResolved.close();
                this.writerResolved = null;
            }
            if (this.writerUnresolved != null) {
                this.writerUnresolved.flush();
                this.writerUnresolved.close();
                this.writerUnresolved = null;
            }
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(BufferedWriter writer, byte[] receivedData, String comment) throws IOException {
        BufferedWriter bufferedWriter = writer;
        synchronized (bufferedWriter) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            writer.write(df.format(date));
            writer.write(";");
            writer.write('\"' + EBusUtils.toHexDumpString(receivedData[0]) + '\"');
            writer.write(";");
            writer.write('\"' + EBusUtils.toHexDumpString(receivedData[1]) + '\"');
            writer.write(";");
            byte[] command = Arrays.copyOfRange(receivedData, 2, 4);
            writer.write('\"' + EBusUtils.toHexDumpString(command).toString() + '\"');
            writer.write(";");
            byte[] rest = Arrays.copyOfRange(receivedData, 4, receivedData.length);
            writer.write('\"' + EBusUtils.toHexDumpString(rest).toString() + '\"');
            writer.write(";");
            writer.write(comment);
            writer.newLine();
            writer.flush();
        }
    }
}

