/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.service.device;

import de.csdev.ebus.service.device.EBusDeviceTable;
import de.csdev.ebus.service.device.IEBusDevice;
import de.csdev.ebus.utils.EBusUtils;
import java.math.BigDecimal;
import java.util.Arrays;

public class EBusDevice
implements IEBusDevice {
    private byte[] deviceId;
    private EBusDeviceTable deviceTable;
    private BigDecimal hardwareVersion;
    private long lastActivity;
    private Byte manufacturer;
    private Byte masterAddress;
    private Byte slaveAddress;
    private BigDecimal softwareVersion;

    public EBusDevice(Byte address, EBusDeviceTable deviceTable) {
        this.deviceTable = deviceTable;
        if (EBusUtils.isMasterAddress(address)) {
            this.masterAddress = address;
            this.slaveAddress = EBusUtils.getSlaveAddress(address);
        } else {
            this.slaveAddress = address;
            this.masterAddress = EBusUtils.getMasterAddress(this.slaveAddress);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EBusDevice other = (EBusDevice)obj;
        if (!Arrays.equals(this.deviceId, other.deviceId)) {
            return false;
        }
        if (this.hardwareVersion == null ? other.hardwareVersion != null : !this.hardwareVersion.equals(other.hardwareVersion)) {
            return false;
        }
        if (this.manufacturer != other.manufacturer) {
            return false;
        }
        if (this.masterAddress != other.masterAddress) {
            return false;
        }
        if (this.slaveAddress != other.slaveAddress) {
            return false;
        }
        return !(this.softwareVersion == null ? other.softwareVersion != null : !this.softwareVersion.equals(other.softwareVersion));
    }

    @Override
    public byte[] getDeviceId() {
        return this.deviceId;
    }

    @Override
    public BigDecimal getHardwareVersion() {
        return this.hardwareVersion;
    }

    @Override
    public long getLastActivity() {
        return this.lastActivity;
    }

    @Override
    public Byte getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public String getManufacturerName() {
        if (this.manufacturer != null) {
            return this.deviceTable.getManufacturerName(this.manufacturer);
        }
        return null;
    }

    @Override
    public Byte getMasterAddress() {
        return this.masterAddress;
    }

    @Override
    public Byte getSlaveAddress() {
        return this.slaveAddress;
    }

    @Override
    public BigDecimal getSoftwareVersion() {
        return this.softwareVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.deviceId);
        result = 31 * result + (this.hardwareVersion == null ? 0 : this.hardwareVersion.hashCode());
        result = 31 * result + this.manufacturer;
        result = 31 * result + this.masterAddress;
        result = 31 * result + this.slaveAddress;
        result = 31 * result + (this.softwareVersion == null ? 0 : this.softwareVersion.hashCode());
        return result;
    }

    public void setDeviceId(byte[] deviceId) {
        this.deviceId = deviceId;
    }

    public void setHardwareVersion(BigDecimal hardwareVersion) {
        this.hardwareVersion = hardwareVersion;
    }

    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    public void setManufacturer(Byte manufactur) {
        this.manufacturer = manufactur;
    }

    public void setSoftwareVersion(BigDecimal softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String toString() {
        return "EBusDevice [masterAddress=0x" + EBusUtils.toHexDumpString(this.masterAddress) + ", slaveAddress=0x" + EBusUtils.toHexDumpString(this.slaveAddress) + ", lastActivity=" + this.lastActivity + ", manufacturer=" + this.manufacturer + "(" + this.getManufacturerName() + "), deviceId=" + EBusUtils.toHexDumpString(this.deviceId).toString() + ", softwareVersion=" + this.softwareVersion + ", hardwareVersion=" + this.hardwareVersion + "]";
    }
}

