/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core.connection;

import com.fazecast.jSerialComm.SerialPort;
import de.csdev.ebus.core.connection.AbstractEBusConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusJSerialCommConnection
extends AbstractEBusConnection {
    private static final Logger logger = LoggerFactory.getLogger(EBusJSerialCommConnection.class);
    private SerialPort serialPort;
    private String port;

    public EBusJSerialCommConnection(String port) {
        this.port = port;
    }

    @Override
    public boolean open() throws IOException {
        this.serialPort = SerialPort.getCommPort((String)this.port);
        this.serialPort.setComPortParameters(2400, 8, 1, 0);
        this.serialPort.openPort(1000, 1, 1);
        this.serialPort.setComPortTimeouts(1, 0, 0);
        this.outputStream = this.serialPort.getOutputStream();
        this.inputStream = this.serialPort.getInputStream();
        return true;
    }

    @Override
    public boolean close() throws IOException {
        if (this.serialPort == null) {
            return true;
        }
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                IOUtils.closeQuietly((InputStream)EBusJSerialCommConnection.this.inputStream);
                IOUtils.closeQuietly((OutputStream)EBusJSerialCommConnection.this.outputStream);
                if (EBusJSerialCommConnection.this.serialPort != null) {
                    EBusJSerialCommConnection.this.serialPort.closePort();
                    EBusJSerialCommConnection.this.serialPort = null;
                }
            }
        }, "eBUS serial shutdown thread");
        shutdownThread.start();
        try {
            shutdownThread.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }
}

