/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core.connection;

import de.csdev.ebus.core.connection.AbstractEBusConnection;
import de.csdev.ebus.utils.Emulator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusEmulatorConnection
extends AbstractEBusConnection {
    private static final Logger logger = LoggerFactory.getLogger(EBusEmulatorConnection.class);
    private Emulator emu;
    private boolean autoSync = true;

    public EBusEmulatorConnection() {
    }

    public EBusEmulatorConnection(boolean autoSync) {
        this.autoSync = autoSync;
    }

    @Override
    public boolean open() throws IOException {
        this.emu = new Emulator(1, this.autoSync);
        this.inputStream = this.emu.getInputStream();
        return true;
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.emu.write((byte)b);
    }

    public void writeBytes(byte[] byteArray) {
        this.emu.write(byteArray);
    }

    public void writeBytesDelayed(byte[] byteArray, long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            logger.error("error!", (Throwable)e);
        }
        this.writeBytes(byteArray);
    }

    @Override
    public void reset() throws IOException {
        if (this.emu.getInputStream().available() > 0) {
            byte[] data = new byte[this.emu.getInputStream().available()];
            this.emu.getInputStream().read(data);
        }
    }

    @Override
    public boolean close() throws IOException {
        this.emu.close();
        return super.close();
    }
}

