/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core;

import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.utils.EBusUtils;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusQueue {
    private static final Logger logger = LoggerFactory.getLogger(EBusQueue.class);
    private final Queue<QueueEntry> outputQueue = new LinkedBlockingQueue<QueueEntry>(20);
    private static int LOCKOUT_COUNTER_MAX = 3;
    private QueueEntry sendEntry;
    private boolean lastSendCollisionDetected = false;
    private int lockCounter = 0;
    private boolean blockNextSend = false;
    private boolean blockSend = false;
    private Random random = new Random();

    public boolean isBlockSend() {
        return this.blockSend;
    }

    public void setBlockSend(boolean blockSend) {
        this.blockSend = blockSend;
    }

    public boolean isEmpty() {
        return this.outputQueue.isEmpty();
    }

    public void checkSendStatus(boolean skipLockCounter) throws EBusDataException {
        if (!skipLockCounter) {
            if (this.lockCounter > 0) {
                --this.lockCounter;
            }
            if (this.lockCounter > 0) {
                logger.trace("No access to eBUS because the lock counter ...");
                return;
            }
        }
        if (this.blockNextSend) {
            logger.trace("Sender was blocked for this SYN ...");
            this.blockNextSend = false;
            return;
        }
        if (this.outputQueue.isEmpty()) {
            return;
        }
        if (this.sendEntry != null) {
            if (this.sendEntry.sendAttempts >= this.sendEntry.maxAttemps) {
                QueueEntry tmpEntry = this.sendEntry;
                this.resetSendQueue();
                throw new EBusDataException(String.format("Unable to send telegram %s after %d attempts ...", EBusUtils.toHexDumpString(tmpEntry.buffer), tmpEntry.maxAttemps), EBusDataException.EBusError.TOO_MANY_ATTEMPS, tmpEntry.buffer, tmpEntry.id);
            }
            return;
        }
        this.sendEntry = this.outputQueue.peek();
    }

    public Integer addToSendQueue(byte @NonNull [] buffer) {
        return this.addToSendQueue(buffer, 10);
    }

    public Integer addToSendQueue(byte @NonNull [] buffer, int maxAttemps) {
        Objects.requireNonNull(buffer, "buffer");
        QueueEntry entry = new QueueEntry(buffer);
        entry.maxAttemps = maxAttemps;
        try {
            this.outputQueue.add(entry);
            logger.debug("Size of send queue is {} ...", (Object)this.outputQueue.size());
        }
        catch (IllegalStateException e) {
            logger.error("Send queue is full! The eBUS service will reset the queue to ensure proper operation.");
            this.outputQueue.clear();
            this.resetSendQueue();
            this.outputQueue.add(entry);
        }
        return entry.id;
    }

    public void resetSendQueue() {
        this.lockCounter = LOCKOUT_COUNTER_MAX;
        this.lastSendCollisionDetected = false;
        this.blockNextSend = false;
        this.blockSend = false;
        this.sendEntry = null;
        this.outputQueue.poll();
    }

    public @Nullable QueueEntry getCurrent() {
        return this.sendEntry;
    }

    public boolean isLastSendCollisionDetected() {
        return this.lastSendCollisionDetected;
    }

    public void setLastSendCollisionDetected(boolean lastSendCollisionDetected) {
        this.lastSendCollisionDetected = lastSendCollisionDetected;
    }

    public int getLockCounter() {
        return this.lockCounter;
    }

    public void setLockCounter(int lockCounter) {
        this.lockCounter = lockCounter;
    }

    public boolean isBlockNextSend() {
        return this.blockNextSend;
    }

    public void setBlockNextSend(boolean blockNextSend) {
        this.blockNextSend = blockNextSend;
    }

    public class QueueEntry {
        public byte[] buffer;
        public int id;
        public int maxAttemps = 10;
        public int sendAttempts = 0;
        public boolean secondTry = false;

        public QueueEntry(byte[] buffer) {
            this.buffer = buffer;
            this.id = EBusQueue.this.random.nextInt();
        }
    }
}

