/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core;

import de.csdev.ebus.core.EBusControllerBase;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.core.EBusQueue;
import de.csdev.ebus.core.EBusWorkerThreadFactory;
import de.csdev.ebus.core.IEBusController;
import de.csdev.ebus.utils.EBusUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusEbusdController
extends EBusControllerBase {
    private static final Logger logger = LoggerFactory.getLogger(EBusEbusdController.class);
    private Socket socket;
    private String hostname;
    private int port;
    private BufferedReader reader;
    private Writer writer;
    private int reConnectCounter = 0;
    private boolean directMode = false;
    private Thread senderThread = null;
    private Integer currentSendId = null;

    public EBusEbusdController(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public static String buildEbusdSendString(byte[] buffer) {
        byte[] bs = Arrays.copyOfRange(buffer, 1, buffer.length - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("-s ");
        sb.append(EBusUtils.toHexDumpString(buffer[0]));
        sb.append(" ");
        sb.append(EBusUtils.toHexDumpString(bs).toString().replace(" ", ""));
        return sb.toString();
    }

    private ByteBuffer parseLine(String readLine) throws IOException, InterruptedException, EBusDataException {
        ByteBuffer b;
        block20: {
            b = null;
            try {
                logger.trace("<<--|" + readLine + "|");
                if (readLine == null) {
                    logger.error("End of stream has been reached!");
                    this.reconnect();
                    break block20;
                }
                if (StringUtils.startsWith((String)readLine, (String)"ERR:")) {
                    logger.error(readLine);
                    this.reconnect();
                    break block20;
                }
                if (StringUtils.equals((String)readLine, (String)"direct mode started")) {
                    logger.info("ebusd direct mode enabled!");
                    this.startSenderThread();
                    this.directMode = true;
                    this.setConnectionStatus(IEBusController.ConnectionStatus.CONNECTED);
                    break block20;
                }
                if (readLine.startsWith("version:")) {
                    try {
                        int versio;
                        String[] split = readLine.split(":");
                        String value = StringUtils.trim((String)split[1]);
                        logger.info("Use ebusd version: {}", (Object)value);
                        String version = StringUtils.trim((String)value.split(" ")[1]);
                        String[] versionParts = version.split("\\.");
                        if (NumberUtils.isDigits((String)versionParts[0]) && NumberUtils.isDigits((String)versionParts[1]) && (versio = NumberUtils.createInteger((String)versionParts[0]) * 1000 + NumberUtils.createInteger((String)versionParts[1])) < 3004) {
                            logger.warn("Your ebusd version is not supported. Please use a version >= 3.4 !");
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        logger.error("error!", (Throwable)e);
                    }
                    break block20;
                }
                if (this.directMode) {
                    if (readLine.startsWith("-s")) {
                        String tmp = readLine.substring(3, 5) + readLine.substring(6);
                        EBusQueue.QueueEntry queueEntry = this.queue.getCurrent();
                        if (queueEntry != null) {
                            this.currentSendId = queueEntry.id;
                            this.queue.resetSendQueue();
                        }
                        if (readLine.contains(":")) {
                            String[] split = tmp.split(":");
                            if (split[1].startsWith("done")) {
                                b = this.convertEBusdDataToFullTelegram(EBusUtils.toByteArray2(split[0]), null);
                            } else {
                                if (split[1].startsWith("ERR")) {
                                    throw new EBusDataException(StringUtils.trim((String)split[2]));
                                }
                                b = this.convertEBusdDataToFullTelegram(EBusUtils.toByteArray2(split[0]), EBusUtils.toByteArray2(split[1]));
                            }
                        } else {
                            logger.debug("Unknown send response: {}", (Object)readLine);
                        }
                    } else if (readLine.contains(" ")) {
                        String[] split = readLine.split(" ");
                        b = this.convertEBusdDataToFullTelegram(EBusUtils.toByteArray2(split[0]), EBusUtils.toByteArray2(split[1]));
                    } else {
                        byte[] data = EBusUtils.toByteArray2(readLine);
                        b = this.convertEBusdDataToFullTelegram(data, null);
                    }
                }
            }
            catch (NullPointerException | NumberFormatException e) {
                logger.error("Error while parsing ebusd response: {}", (Object)readLine);
                logger.error("Error Trace!", (Throwable)e);
            }
        }
        return b;
    }

    private void stopSenderThread() {
        if (this.senderThread != null) {
            logger.warn("Stop sender thread!");
            this.senderThread.interrupt();
            this.senderThread = null;
        }
    }

    private void startSenderThread() {
        this.stopSenderThread();
        this.senderThread = new EBusWorkerThreadFactory("ebus-sender", false).newThread(new EBusSenderThread());
        this.senderThread.start();
    }

    @Override
    public void run() {
        try {
            logger.debug("Start ebusd controller thread!");
            this.initThreadPool();
            this.resetWatchdogTimer();
            this.connect();
            while (!this.isInterrupted() && this.reConnectCounter != -1) {
                try {
                    while (!this.isInterrupted()) {
                        if (this.socket == null || !this.socket.isConnected()) {
                            this.reconnect();
                        }
                        if (this.senderThread == null || !this.senderThread.isAlive()) {
                            this.startSenderThread();
                        }
                        String readLine = this.reader.readLine();
                        this.currentSendId = null;
                        ByteBuffer b = this.parseLine(readLine);
                        this.resetWatchdogTimer();
                        this.reConnectCounter = 0;
                        if (b == null) continue;
                        this.fireOnEBusTelegramReceived(EBusUtils.toByteArray(b), this.currentSendId);
                    }
                }
                catch (EBusDataException e) {
                    this.fireOnEBusDataException(e, this.currentSendId);
                }
                catch (InterruptedIOException e) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    logger.error("error!", (Throwable)e);
                    this.fireOnConnectionException(e);
                    try {
                        this.reconnect();
                    }
                    catch (IOException e1) {
                        logger.error(e.toString(), (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("error!", (Throwable)e);
        }
        this.dispose();
    }

    public ByteBuffer convertEBusdDataToFullTelegram(byte[] masterData, byte[] slaveData) {
        ByteBuffer b = ByteBuffer.allocate(100);
        b.put(masterData);
        b.put(EBusUtils.crc8(masterData, masterData.length));
        if (masterData[1] != -2) {
            b.put((byte)0);
        }
        if (slaveData != null && slaveData.length > 0) {
            b.put(slaveData);
            b.put(EBusUtils.crc8(slaveData, slaveData.length));
            b.put((byte)0);
        }
        b.put((byte)-86);
        return b;
    }

    private void reconnect() throws IOException, InterruptedException {
        if (!this.isRunning()) {
            logger.trace("Skip reconnect, thread was interrupted ...");
            return;
        }
        logger.info("Try to reconnect to ebusd daemon ...");
        this.setConnectionStatus(IEBusController.ConnectionStatus.CONNECTING);
        if (this.reConnectCounter > 10) {
            this.reConnectCounter = -1;
            this.interrupt();
        } else {
            ++this.reConnectCounter;
            logger.warn("Retry to connect to ebusd daemon in {} seconds ...", (Object)(5 * this.reConnectCounter));
            Thread.sleep(5000 * this.reConnectCounter);
            this.disconnect();
            if (this.connect()) {
                this.resetWatchdogTimer();
            }
        }
    }

    private void disconnect() {
        this.stopSenderThread();
        IOUtils.closeQuietly((Reader)this.reader);
        this.reader = null;
        IOUtils.closeQuietly((Writer)this.writer);
        this.writer = null;
        IOUtils.closeQuietly((Socket)this.socket);
        this.socket = null;
        this.directMode = false;
        this.setConnectionStatus(IEBusController.ConnectionStatus.DISCONNECTED);
    }

    private boolean connect() throws UnknownHostException, IOException {
        logger.info("Run connect ...");
        this.socket = new Socket(this.hostname, this.port);
        this.socket.setSoTimeout(20000);
        this.socket.setKeepAlive(true);
        if (this.socket.isConnected()) {
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new OutputStreamWriter(this.socket.getOutputStream());
            try {
                this.writer.write("info\n");
                this.writer.flush();
                Thread.sleep(100L);
                logger.info("Run direct mode ...");
                this.writer.write("direct\n");
                this.writer.flush();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    protected void fireWatchDogTimer() {
        logger.warn("eBUS Watchdog Timer!");
        this.disconnect();
    }

    @Override
    protected void dispose() {
        logger.debug("eBUS connection thread is shutting down ...");
        this.disconnect();
        super.dispose();
    }

    @Override
    public long getLastSendReceiveRoundtripTime() {
        return 0L;
    }

    public class EBusSenderThread
    extends Thread {
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    EBusQueue queue = EBusEbusdController.this.queue;
                    if (queue != null) {
                        EBusQueue.QueueEntry queueEntry = queue.getCurrent();
                        if (!queue.isBlockSend() && queueEntry != null) {
                            ++queueEntry.sendAttempts;
                            logger.trace("-->>|" + EBusEbusdController.buildEbusdSendString(queueEntry.buffer) + "|");
                            EBusEbusdController.this.writer.write(EBusEbusdController.buildEbusdSendString(queueEntry.buffer) + "\n");
                            EBusEbusdController.this.writer.flush();
                            queue.setBlockSend(true);
                        }
                        queue.checkSendStatus(true);
                    }
                    Thread.sleep(100L);
                }
                catch (EBusDataException | IOException e) {
                    logger.error("error!", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            EBusEbusdController.this.senderThread = null;
        }
    }
}

