/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core;

import de.csdev.ebus.utils.EBusUtils;
import java.nio.ByteBuffer;

public class EBusDataException
extends Exception {
    private static final long serialVersionUID = 1L;
    private EBusError error = EBusError.NONE;
    private byte[] data;
    private Integer sendId;

    public EBusDataException(String message) {
        super(message);
    }

    public EBusDataException(String message, EBusError errorCode) {
        super(message);
        this.error = errorCode;
    }

    public EBusDataException(String message, EBusError errorCode, byte[] data) {
        this(message, errorCode);
        this.data = data;
    }

    public EBusDataException(String message, EBusError errorCode, ByteBuffer data) {
        this(message, errorCode);
        this.data = EBusUtils.toByteArray(data);
    }

    public EBusDataException(String message, EBusError errorCode, byte[] data, int sendId) {
        this(message, errorCode);
        this.data = data;
        this.sendId = sendId;
    }

    public EBusDataException(String message, EBusError errorCode, ByteBuffer data, int sendId) {
        this(message, errorCode);
        this.data = EBusUtils.toByteArray(data);
        this.sendId = sendId;
    }

    public EBusError getErrorCode() {
        return this.error;
    }

    public byte[] getData() {
        return this.data;
    }

    public Integer getSendId() {
        return this.sendId;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getMessage());
        sb.append(" [");
        if (!this.error.equals((Object)EBusError.NONE)) {
            sb.append("ERROR: ");
            sb.append(this.error.name());
            sb.append(", ");
        }
        if (this.data != null) {
            sb.append("DATA: ");
            sb.append((CharSequence)EBusUtils.toHexDumpString(this.data));
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum EBusError {
        NONE,
        MASTER_CRC_INVALID,
        SLAVE_CRC_INVALID,
        NO_SLAVE_RESPONSE,
        UNEXPECTED_RESPONSE,
        BUFFER_FULL,
        INVALID_SYN,
        INVALID_SOURCE_ADDRESS,
        INVALID_MASTER_LEN,
        INVALID_SLAVE_LEN,
        MASTER_ACK_FAIL,
        SLAVE_ACK_FAIL,
        TOO_MANY_ATTEMPS;

    }
}

