/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.utils.EBusTypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractEBusTypeNumber
extends EBusAbstractType<BigDecimal> {
    @Override
    public byte[] getReplaceValue() {
        int length = this.getTypeLength();
        if (this.replaceValue == null || this.replaceValue.length == 0) {
            this.replaceValue = new byte[length];
            this.replaceValue[length - 1] = -128;
        }
        return this.replaceValue;
    }

    @Override
    public BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        byte[] clone = ArrayUtils.clone((byte[])data);
        ArrayUtils.reverse((byte[])clone);
        return new BigDecimal(new BigInteger(clone));
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = EBusTypeUtils.toBigDecimal(data == null ? Integer.valueOf(0) : data);
        long l = b.longValue();
        int length = this.getTypeLength();
        byte[] result = new byte[length];
        for (int i = 0; i <= length - 1; ++i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }
}

