/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command;

import de.csdev.ebus.command.EBusCommand;
import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.command.IEBusCommand;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.IEBusValue;
import de.csdev.ebus.utils.EBusUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EBusCommandMethod
implements IEBusCommandMethod {
    private byte[] command;
    private Byte destinationAddress;
    private List<@NonNull IEBusValue> masterTypes;
    private @NonNull IEBusCommandMethod.Method method;
    private @NonNull IEBusCommand parent;
    private List<@NonNull IEBusValue> slaveTypes;
    private Byte sourceAddress;
    private ByteBuffer telegramMask;
    private IEBusCommandMethod.Type type;

    public EBusCommandMethod(EBusCommand parent, IEBusCommandMethod.Method method) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(method);
        this.parent = parent;
        this.method = method;
        parent.addCommandChannel(this);
    }

    public EBusCommandMethod addMasterValue(IEBusValue value) {
        if (this.masterTypes == null) {
            this.masterTypes = new ArrayList<IEBusValue>();
        }
        if (value != null) {
            this.masterTypes.add(value);
        }
        return this;
    }

    public EBusCommandMethod addSlaveValue(IEBusValue value) {
        if (this.slaveTypes == null) {
            this.slaveTypes = new ArrayList<IEBusValue>();
        }
        if (value != null) {
            this.slaveTypes.add(value);
        }
        return this;
    }

    @Override
    public byte @NonNull [] getCommand() {
        return Objects.requireNonNull(this.command);
    }

    @Override
    public Byte getDestinationAddress() {
        return this.destinationAddress;
    }

    @Override
    public @NonNull ByteBuffer getMasterTelegramMask() {
        if (this.telegramMask == null) {
            this.telegramMask = EBusCommandUtils.getMasterTelegramMask(this);
        }
        return Objects.requireNonNull(this.telegramMask);
    }

    @Override
    public @Nullable List<@NonNull IEBusValue> getMasterTypes() {
        return this.masterTypes;
    }

    @Override
    public @NonNull IEBusCommandMethod.Method getMethod() {
        return this.method;
    }

    @Override
    public @NonNull IEBusCommand getParent() {
        return this.parent;
    }

    @Override
    public @Nullable List<@NonNull IEBusValue> getSlaveTypes() {
        return this.slaveTypes;
    }

    @Override
    public Byte getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public @NonNull IEBusCommandMethod.Type getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.method.equals((Object)IEBusCommandMethod.Method.BROADCAST)) {
            return IEBusCommandMethod.Type.BROADCAST;
        }
        return IEBusCommandMethod.Type.MASTER_SLAVE;
    }

    public EBusCommandMethod setCommand(byte[] command) {
        this.command = command;
        return this;
    }

    public void setDestinationAddress(Byte destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public void setMasterTypes(List<@NonNull IEBusValue> masterTypes) {
        this.masterTypes = masterTypes;
    }

    public void setSlaveTypes(List<@NonNull IEBusValue> slaveTypes) {
        this.slaveTypes = slaveTypes;
    }

    public void setSourceAddress(Byte sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public void setType(IEBusCommandMethod.Type type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EBusCommandMethod [");
        sb.append("command=" + EBusUtils.toHexDumpString(this.command).toString() + ", ");
        if (this.destinationAddress != null) {
            sb.append("destinationAddress=" + EBusUtils.toPrintHexDumpString(this.destinationAddress) + ", ");
        }
        if (this.sourceAddress != null) {
            sb.append("sourceAddress=" + EBusUtils.toPrintHexDumpString(this.sourceAddress) + ", ");
        }
        sb.append("masterTypes=" + this.masterTypes + ", ");
        sb.append("slaveTypes=" + this.slaveTypes + ", ");
        sb.append("method=" + (Object)((Object)this.method));
        sb.append("type=" + (Object)((Object)this.type));
        sb.append("]");
        return sb.toString();
    }
}

