/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.cfg.std.dto;

import com.google.gson.annotations.SerializedName;
import de.csdev.ebus.utils.CollectionUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusValueDTO {
    private final transient Logger logger = LoggerFactory.getLogger(EBusValueDTO.class);
    @SerializedName(value="default")
    private String _default;
    private @Nullable List<EBusValueDTO> children;
    private @Nullable BigDecimal divider;
    private @Nullable BigDecimal factor;
    private @Nullable String format;
    private @Nullable String label;
    private @Nullable Integer length;
    private @Nullable Map<String, String> mapping;
    private @Nullable BigDecimal max;
    private @Nullable BigDecimal min;
    private @Nullable String name;
    private @Nullable Integer pos;
    private @Nullable Map<String, Object> properties;
    private @Nullable String replaceValue;
    private boolean reverseByteOrder = false;
    private @Nullable BigDecimal step;
    private @Nullable String type;

    public Map<String, Object> getAsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                Object value = field.get(this);
                if (field.getName().equals("logger") || value == null) continue;
                map.put(field.getName(), value);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("error!", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error("error!", (Throwable)e);
            }
        }
        if (this.properties != null) {
            map.putAll(this.properties);
        }
        return map;
    }

    public @Nullable List<EBusValueDTO> getChildren() {
        return this.children;
    }

    public @Nullable String getDefault() {
        return this._default;
    }

    public @Nullable BigDecimal getDivider() {
        return this.divider;
    }

    public @Nullable BigDecimal getFactor() {
        return this.factor;
    }

    public @Nullable String getFormat() {
        return this.format;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable Integer getLength() {
        return this.length;
    }

    public @Nullable Map<String, String> getMapping() {
        return this.mapping;
    }

    public @Nullable BigDecimal getMax() {
        return this.max;
    }

    public @Nullable BigDecimal getMin() {
        return this.min;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable Integer getPos() {
        return this.pos;
    }

    public Map<String, Object> getProperties() {
        this.properties = CollectionUtils.newMapIfNull(this.properties);
        return CollectionUtils.unmodifiableNotNullMap(this.properties);
    }

    public Object getProperty(String key) {
        return CollectionUtils.get(this.properties, key);
    }

    public @Nullable String getReplaceValue() {
        return this.replaceValue;
    }

    public @Nullable BigDecimal getStep() {
        return this.step;
    }

    public @Nullable String getType() {
        return this.type;
    }

    public boolean isReverseByteOrder() {
        return this.reverseByteOrder;
    }

    public void setChildren(List<EBusValueDTO> children) {
        this.children = children;
    }

    public void setDefault(String _default) {
        this._default = _default;
    }

    public void setDivider(BigDecimal divider) {
        this.divider = divider;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setMapping(Map<String, String> mapping) {
        this.mapping = mapping;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPos(Integer pos) {
        this.pos = pos;
    }

    public void setProperty(String key, Object value) {
        this.properties = CollectionUtils.newMapIfNull(this.properties);
        if (this.properties != null) {
            this.properties.put(key, value);
        }
    }

    public void setReplaceValue(String replaceValue) {
        this.replaceValue = replaceValue;
    }

    public void setReverseByteOrder(boolean reverseByteOrder) {
        this.reverseByteOrder = reverseByteOrder;
    }

    public void setStep(BigDecimal step) {
        this.step = step;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "EBusValueDTO [" + (this.children != null ? "children=" + this.children + ", " : "") + (this.factor != null ? "factor=" + this.factor + ", " : "") + (this.divider != null ? "divider=" + this.divider + ", " : "") + (this.label != null ? "label=" + this.label + ", " : "") + (this.length != null ? "length=" + this.length + ", " : "") + (this.mapping != null ? "mapping=" + this.mapping + ", " : "") + (this.max != null ? "max=" + this.max + ", " : "") + (this.min != null ? "min=" + this.min + ", " : "") + (this.name != null ? "name=" + this.name + ", " : "") + (this.replaceValue != null ? "replaceValue=" + this.replaceValue + ", " : "") + (this.step != null ? "step=" + this.step + ", " : "") + (this.type != null ? "type=" + this.type + ", " : "") + (this._default != null ? "_default=" + this._default + ", " : "") + (this.pos != null ? "pos=" + this.pos + ", " : "") + (this.format != null ? "format=" + this.format + ", " : "") + "reverseByteOrder=" + this.reverseByteOrder + ", " + (this.properties != null ? "properties=" + this.properties : "") + "]";
    }
}

