/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.maven.plugin;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.crowdcode.kissmda.core.Context;
import de.crowdcode.kissmda.core.CoreModule;
import de.crowdcode.kissmda.core.StandardContext;
import de.crowdcode.kissmda.core.Transformer;
import de.crowdcode.kissmda.core.TransformerException;
import de.crowdcode.kissmda.maven.plugin.LoggingLevelMapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class KissMdaMojo
extends AbstractMojo {
    private final Log logger = this.getLog();
    private static final String TRANSFORMER_SUFFIX = "Transformer";
    private static final String MODULE_SUFFIX = "Module";
    public static final String ERROR_GUICE_SAME_PACKAGE_NOT_FOUND = "Error Guice module for the transformer in the same package not found!";
    protected MavenProject project;
    private List<String> transformerScanPackageNames;
    private List<String> transformerNameWithOrders;
    private String modelFile;
    private String targetEncoding;
    private String generatedSourcesTargetDirectory;
    private String loggingLevel;
    private String propertyFile;
    private final StandardContext context;
    private final LoggingLevelMapper loggingLevelMapper = new LoggingLevelMapper();

    public KissMdaMojo() {
        this.context = new StandardContext();
    }

    public StandardContext getContext() {
        return this.context;
    }

    public void setGeneratedSourcesTargetDirectory(String generatedSourcesTargetDirectory) {
        this.generatedSourcesTargetDirectory = generatedSourcesTargetDirectory;
    }

    public void setModelFile(String modelFile) {
        this.modelFile = modelFile;
    }

    public void setTransformerScanPackageNames(List<String> transformerScanPackageNames) {
        this.transformerScanPackageNames = transformerScanPackageNames;
    }

    public void setTransformerNameWithOrders(List<String> transformerNameWithOrders) {
        this.transformerNameWithOrders = transformerNameWithOrders;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setTargetEncoding(String targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void execute() throws MojoExecutionException {
        this.logger.info((CharSequence)"Start KissMdaMojo...");
        this.setLoggingLevel();
        try {
            Injector parentInjector = Guice.createInjector((Module[])new Module[]{new CoreModule(this.context)});
            String fullNameModelFile = this.project.getBasedir() + "/" + this.modelFile;
            String fullNameTargetDirectory = this.project.getBasedir() + "/" + this.generatedSourcesTargetDirectory;
            this.context.setSourceModel(fullNameModelFile);
            this.context.setTargetModel(fullNameTargetDirectory);
            this.context.setTargetEncoding(this.targetEncoding);
            this.context.setPropertyFile(this.propertyFile);
            if (this.transformerNameWithOrders != null && this.transformerNameWithOrders.size() != 0) {
                this.useTransformerNamesWithOrder(parentInjector);
            } else {
                this.useTransformerScanPackageNames(parentInjector);
            }
            this.logger.info((CharSequence)"Stop KissMdaMojo without error...");
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void useTransformerScanPackageNames(Injector parentInjector) throws MojoExecutionException, InstantiationException, IllegalAccessException {
        for (String packageName : this.transformerScanPackageNames) {
            Reflections reflections = new Reflections(packageName, new Scanner[0]);
            Set transformers = reflections.getSubTypesOf(Transformer.class);
            Set guiceModules = reflections.getSubTypesOf(AbstractModule.class);
            for (Class transformerClazz : transformers) {
                this.logger.info((CharSequence)("Start the transformation with following Transformer: " + transformerClazz.getName()));
                Class<? extends AbstractModule> guiceModuleClazz = this.getGuiceModule(guiceModules, transformerClazz);
                Injector injector = parentInjector.createChildInjector(new Module[]{(Module)guiceModuleClazz.newInstance()});
                Transformer transformer = (Transformer)injector.getInstance(transformerClazz);
                transformer.transform((Context)this.context);
                this.logger.info((CharSequence)("Stop the transformation with following Transformer:" + transformerClazz.getName()));
            }
        }
    }

    private void useTransformerNamesWithOrder(Injector parentInjector) throws MojoExecutionException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object transformerClazz;
        TreeMap<Integer, String> sortedtTransformerNameWithOrders = new TreeMap<Integer, String>();
        for (String string : this.transformerNameWithOrders) {
            String order = StringUtils.substringBefore((String)string, (String)":");
            Integer orderAsInt = Integer.decode(order);
            transformerClazz = StringUtils.substringAfter((String)string, (String)":");
            sortedtTransformerNameWithOrders.put(orderAsInt, (String)transformerClazz);
        }
        for (Map.Entry entry : sortedtTransformerNameWithOrders.entrySet()) {
            String transformerClazzName = (String)entry.getValue();
            String guiceModuleClazzName = this.getGuiceModuleName(transformerClazzName);
            transformerClazz = Class.forName(transformerClazzName).asSubclass(Transformer.class);
            Class<Module> guiceModuleClazz = Class.forName(guiceModuleClazzName).asSubclass(Module.class);
            this.logger.info((CharSequence)("Start the transformation with following Transformer: " + transformerClazzName + " - order: " + entry.getKey()));
            Injector injector = parentInjector.createChildInjector(new Module[]{guiceModuleClazz.newInstance()});
            Transformer transformer = (Transformer)injector.getInstance((Class)transformerClazz);
            transformer.transform((Context)this.context);
            this.logger.info((CharSequence)("Stop the transformation with following Transformer:" + transformerClazzName));
        }
    }

    String getGuiceModuleName(String transformerClazzName) {
        String guiceModuleClazzName = StringUtils.replace((String)transformerClazzName, (String)TRANSFORMER_SUFFIX, (String)MODULE_SUFFIX);
        return guiceModuleClazzName;
    }

    private void setLoggingLevel() {
        Logger log = LogManager.getLogManager().getLogger("");
        if (this.loggingLevel == null || this.loggingLevel.equals("")) {
            log.setLevel(Level.INFO);
        } else {
            log.setLevel(this.loggingLevelMapper.getLevel(this.loggingLevel));
        }
        for (Handler handler : log.getHandlers()) {
            if (this.loggingLevel == null || this.loggingLevel.equals("")) {
                handler.setLevel(Level.INFO);
                continue;
            }
            handler.setLevel(this.loggingLevelMapper.getLevel(this.loggingLevel));
        }
    }

    private Class<? extends AbstractModule> getGuiceModule(Set<Class<? extends AbstractModule>> guiceModules, Class<? extends Transformer> transformerClazz) throws MojoExecutionException {
        Class<? extends AbstractModule> currentGuiceModuleClazz = null;
        for (Class<? extends AbstractModule> guiceModuleClazz : guiceModules) {
            String transformerNameWithoutTransformer;
            String guiceModuleNameWithoutModule;
            String transformerPackageName = transformerClazz.getPackage().getName();
            String guiceModulePackageName = guiceModuleClazz.getPackage().getName();
            if (!guiceModulePackageName.equalsIgnoreCase(transformerPackageName) || !(guiceModuleNameWithoutModule = StringUtils.replace((String)guiceModuleClazz.getName(), (String)MODULE_SUFFIX, (String)"")).equals(transformerNameWithoutTransformer = StringUtils.replace((String)transformerClazz.getName(), (String)TRANSFORMER_SUFFIX, (String)""))) continue;
            currentGuiceModuleClazz = guiceModuleClazz;
            this.logger.info((CharSequence)("Start the transformation with following Guice Module: " + currentGuiceModuleClazz.getName()));
            break;
        }
        if (currentGuiceModuleClazz == null) {
            throw new MojoExecutionException(ERROR_GUICE_SAME_PACKAGE_NOT_FOUND);
        }
        return currentGuiceModuleClazz;
    }
}

