/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.maven.plugin;

import de.crowdcode.kissmda.core.StandardContext;
import de.crowdcode.kissmda.maven.plugin.KissMdaMojo;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KissMdaMojoTest {
    private KissMdaMojo kissMdaMojo;

    @Before
    public void setUp() throws Exception {
        this.kissMdaMojo = new KissMdaMojo();
    }

    @Test
    public void testExecuteOk() throws MojoExecutionException {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("de.crowdcode.kissmda.maven.plugin.withguice");
        MavenProject mavenProject = new MavenProject();
        mavenProject.setFile(new File("target/tmp/test"));
        this.kissMdaMojo.setTransformerScanPackageNames(packageNames);
        this.kissMdaMojo.setModelFile("src/main/resources/model/emf/test-uml.uml");
        this.kissMdaMojo.setProject(mavenProject);
        this.kissMdaMojo.execute();
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testExecuteNoGuiceModule() {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("de.crowdcode.kissmda.maven.plugin.noguice");
        MavenProject mavenProject = new MavenProject();
        mavenProject.setFile(new File("target/tmp/test"));
        this.kissMdaMojo.setTransformerScanPackageNames(packageNames);
        this.kissMdaMojo.setModelFile("src/main/resources/model/emf/test-uml.uml");
        this.kissMdaMojo.setProject(mavenProject);
        try {
            this.kissMdaMojo.execute();
        }
        catch (MojoExecutionException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Error Guice module for the transformer not found!");
        }
    }

    @Test
    public void testExecuteWithGuiceModuleButInTheDifferentPackage() {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("de.crowdcode.kissmda.maven.plugin.differentpackage");
        MavenProject mavenProject = new MavenProject();
        mavenProject.setFile(new File("target/tmp/test"));
        this.kissMdaMojo.setTransformerScanPackageNames(packageNames);
        this.kissMdaMojo.setModelFile("src/main/resources/model/emf/test-uml.uml");
        this.kissMdaMojo.setProject(mavenProject);
        try {
            this.kissMdaMojo.execute();
        }
        catch (MojoExecutionException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Error Guice module for the transformer in the same package not found!");
        }
    }

    @Test
    public void testContextObject() throws MojoExecutionException {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("de.crowdcode.kissmda.maven.plugin.withguice");
        MavenProject mavenProject = new MavenProject();
        mavenProject.setFile(new File("target/tmp/test"));
        this.kissMdaMojo.setTransformerScanPackageNames(packageNames);
        this.kissMdaMojo.setModelFile("src/main/resources/model/emf/test-uml.uml");
        this.kissMdaMojo.setGeneratedSourcesTargetDirectory("target/generated-sources/kissmda");
        this.kissMdaMojo.setProject(mavenProject);
        this.kissMdaMojo.execute();
        StandardContext context = this.kissMdaMojo.getContext();
        String resultSourceModel = context.getSourceModel().replace("\\", ".");
        resultSourceModel = resultSourceModel.replace("/", ".");
        String resultTargetModel = context.getTargetModel().replace("\\", ".");
        resultTargetModel = resultTargetModel.replace("/", ".");
        Assert.assertEquals((Object)resultSourceModel, (Object)"target.tmp.src.main.resources.model.emf.test-uml.uml");
        Assert.assertEquals((Object)resultTargetModel, (Object)"target.tmp.target.generated-sources.kissmda");
    }
}

