/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.maven.plugin;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.crowdcode.kissmda.core.Context;
import de.crowdcode.kissmda.core.StandardContext;
import de.crowdcode.kissmda.core.Transformer;
import de.crowdcode.kissmda.core.TransformerException;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class KissMdaMojo
extends AbstractMojo {
    private final Log logger = this.getLog();
    public static final String ERROR_GUICE_NOT_FOUND = "Error Guice module for the transformer not found!";
    public static final String ERROR_GUICE_SAME_PACKAGE_NOT_FOUND = "Error Guice module for the transformer in the same package not found!";
    protected MavenProject project;
    private List<String> transformerScanPackageNames;
    private String modelFile;
    private String generatedSourcesTargetDirectory;
    private final StandardContext context = new StandardContext();

    public StandardContext getContext() {
        return this.context;
    }

    public void setGeneratedSourcesTargetDirectory(String generatedSourcesTargetDirectory) {
        this.generatedSourcesTargetDirectory = generatedSourcesTargetDirectory;
    }

    public void setModelFile(String modelFile) {
        this.modelFile = modelFile;
    }

    public void setTransformerScanPackageNames(List<String> transformerScanPackageNames) {
        this.transformerScanPackageNames = transformerScanPackageNames;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException {
        this.logger.info((CharSequence)"Start KissMdaMojo...");
        try {
            String fullNameModelFile = this.project.getBasedir() + "/" + this.modelFile;
            String fullNameTargetDirectory = this.project.getBasedir() + "/" + this.generatedSourcesTargetDirectory;
            this.context.setSourceModel(fullNameModelFile);
            this.context.setTargetModel(fullNameTargetDirectory);
            for (String packageName : this.transformerScanPackageNames) {
                Reflections reflections = new Reflections(packageName, new Scanner[0]);
                Set transformers = reflections.getSubTypesOf(Transformer.class);
                Set guiceModules = reflections.getSubTypesOf(AbstractModule.class);
                for (Class transformerClazz : transformers) {
                    this.logger.info((CharSequence)("Start the transformation with following Transformer: " + transformerClazz.getName()));
                    Class<? extends AbstractModule> guiceModuleClazz = this.getGuiceModule(guiceModules, transformerClazz);
                    Injector injector = Guice.createInjector((Module[])new Module[]{(Module)guiceModuleClazz.newInstance()});
                    Transformer transformer = (Transformer)injector.getInstance(transformerClazz);
                    transformer.transform((Context)this.context);
                    this.logger.info((CharSequence)("Stop the transformation with following Transformer:" + transformerClazz.getName()));
                }
            }
            this.logger.info((CharSequence)"Stop KissMdaMojo without error...");
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Error transform the model: " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    private Class<? extends AbstractModule> getGuiceModule(Set<Class<? extends AbstractModule>> guiceModules, Class<? extends Transformer> transformerClazz) throws MojoExecutionException {
        Class<? extends AbstractModule> currentGuiceModuleClazz = null;
        for (Class<? extends AbstractModule> guiceModuleClazz : guiceModules) {
            this.logger.info((CharSequence)("Start the transformation with following Guice Module: " + guiceModuleClazz.getName()));
            String transformerPackageName = transformerClazz.getPackage().getName();
            String guiceModulePackageName = guiceModuleClazz.getPackage().getName();
            if (guiceModulePackageName.equalsIgnoreCase(transformerPackageName)) {
                currentGuiceModuleClazz = guiceModuleClazz;
                continue;
            }
            throw new MojoExecutionException(ERROR_GUICE_SAME_PACKAGE_NOT_FOUND);
        }
        if (currentGuiceModuleClazz == null) {
            throw new MojoExecutionException(ERROR_GUICE_NOT_FOUND);
        }
        return currentGuiceModuleClazz;
    }
}

