package de.crowdcode.kissmda.testapp;
/**
 * This is the Address entity. We save each Address in the database.
 * 
 * @author Lofi Dewanto
 * @version 1.0.0
 * @since 1.0.0
 */
public interface Address {
	/**
	 * Get the old address of the current person.
	 */
	de.crowdcode.kissmda.testapp.Address getOldAddress();
	java.util.Collection getOldAddresses();
	java.util.Collection<String> getNewAddresses();
	/**
	 * The street of this address.
	 */
	String getStreet();
	/**
	 * The street of this address.
	 */
	void setStreet(String street);
	de.crowdcode.kissmda.testapp.Person getPerson();
	void setPerson(de.crowdcode.kissmda.testapp.Person person);
	de.crowdcode.kissmda.testapp.AddressType getAddressType();
	void setAddressType(de.crowdcode.kissmda.testapp.AddressType addressType);
	java.util.SortedSet<de.crowdcode.kissmda.testapp.Person> getNewPersons();
	void addNewPersons(de.crowdcode.kissmda.testapp.Person newPerson);
	boolean isOld();
	void setOld(boolean old);
	de.crowdcode.kissmda.testapp.AddressSimpleType getAddressSimpleType();
	void setAddressSimpleType(
			de.crowdcode.kissmda.testapp.AddressSimpleType addressSimpleType);
}
