/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.examples.apptest;

import de.crowdcode.kissmda.examples.apptest.AddressImpl;
import de.crowdcode.kissmda.examples.apptest.AddressServiceImpl;
import de.crowdcode.kissmda.examples.apptest.PersonImpl;
import de.crowdcode.kissmda.examples.apptest.PrivateAddressServiceImpl;
import de.crowdcode.kissmda.examples.apptest.PrivateCompanyImpl;
import de.crowdcode.kissmda.examples.apptest.components.CompanyAttributeImpl;
import de.crowdcode.kissmda.examples.apptest.components.CompanyImpl;
import de.crowdcode.kissmda.testapp.Address;
import de.crowdcode.kissmda.testapp.AddressService;
import de.crowdcode.kissmda.testapp.AddressType;
import de.crowdcode.kissmda.testapp.Person;
import de.crowdcode.kissmda.testapp.PrivateAddressService;
import de.crowdcode.kissmda.testapp.PrivateCompany;
import de.crowdcode.kissmda.testapp.components.Company;
import de.crowdcode.kissmda.testapp.components.CompanyAttribute;
import de.crowdcode.kissmda.testapp.exceptions.CreateAddressException;
import de.crowdcode.kissmda.testapp.exceptions.CreatePersonException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddressServiceImplTest {
    private Person person;
    private AddressService addressService;
    private PrivateAddressService privateAddressService;

    @Before
    public void setUp() throws Exception {
        this.person = new PersonImpl();
        this.person.setName("Lofi");
        this.addressService = new AddressServiceImpl();
        this.privateAddressService = new PrivateAddressServiceImpl();
    }

    @Test
    public void testCreateAddressFromPerson() throws CreateAddressException, CreatePersonException {
        Address address = this.prepareAddressAndCompany();
        Assert.assertEquals(null, (Object)address.getPerson());
        this.addressService.createAddressFromPerson(address, this.person);
        Assert.assertEquals((Object)this.person, (Object)address.getPerson());
    }

    @Test
    public void testCreateAddressFromPersonWithPrivateAddressService() throws CreateAddressException, CreatePersonException {
        Address address = this.prepareAddressAndCompany();
        Assert.assertEquals(null, (Object)address.getPerson());
        this.privateAddressService.createAddressFromPerson(address, this.person);
        Assert.assertEquals((Object)this.person, (Object)address.getPerson());
    }

    @Test
    public void testCreatePrivateAddressFromPerson() {
        Address address = this.prepareAddressAndCompany();
        Assert.assertEquals(null, (Object)address.getPerson());
        this.privateAddressService.createPrivateAddressFromPerson(address, this.person);
        Assert.assertEquals((Object)this.person, (Object)address.getPerson());
    }

    @Test
    public void testGetPrivateCompanyByPerson() {
        Address address = this.prepareAddressAndCompany();
        PrivateCompanyImpl privateCompany = new PrivateCompanyImpl();
        Company company = this.privateAddressService.getPrivateCompanyByPerson(address.getPerson(), (PrivateCompany)privateCompany);
        Assert.assertEquals((Object)company.getName(), (Object)privateCompany.getName());
    }

    private Address prepareAddressAndCompany() {
        CompanyImpl company = new CompanyImpl();
        company.setName("CrowdCode");
        CompanyAttributeImpl companyAttribute = new CompanyAttributeImpl();
        companyAttribute.setName("Lofi");
        companyAttribute.add((Object)"Test Element", (Object)23);
        company.setCompanyAttribute((CompanyAttribute)companyAttribute);
        String owner = "Lofi";
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(owner);
        company.defineCompany(owners, (Object)owner);
        AddressImpl address = new AddressImpl();
        address.setStreet("Jakarta");
        address.setAddressType(AddressType.HOME);
        return address;
    }
}

