/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.proxy.ssh;

import com.jcraft.jsch.ConfigRepository;
import de.cronn.proxy.ssh.SshConfiguration;
import de.cronn.proxy.ssh.util.Assert;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshProxyConfig {
    private static final Logger log = LoggerFactory.getLogger(SshProxyConfig.class);
    private static final Pattern SSH_PROXY_COMMAND_PATTERN = Pattern.compile("ssh -q -W ([\\w\\.\\-_0-9]+|%h):(\\d+|%p) (.+)");
    private final int forwardingPort;
    private final String forwardingHost;
    private final String jumpHost;

    public SshProxyConfig(int forwardingPort, String forwardingHost, String jumpHost) {
        this.forwardingPort = forwardingPort;
        this.forwardingHost = forwardingHost;
        this.jumpHost = jumpHost;
    }

    public static SshProxyConfig parseProxyCommand(String proxyCommandConfig, String sshTunnelHost, ConfigRepository.Config hostConfig) {
        int forwardingPort;
        String portConfig;
        Matcher matcher = SSH_PROXY_COMMAND_PATTERN.matcher(proxyCommandConfig);
        Assert.isTrue(matcher.matches(), "Illegal ProxyCommand configured for host " + sshTunnelHost + ": " + proxyCommandConfig + ". Please check your SSH configuration in " + SshConfiguration.getLocalSshConfigPath());
        log.debug("[{}] emulating proxy command: {}", (Object)sshTunnelHost, (Object)proxyCommandConfig);
        String forwardingHost = matcher.group(1);
        if ("%h".equals(forwardingHost) && (forwardingHost = hostConfig.getHostname()) == null) {
            forwardingHost = sshTunnelHost;
        }
        if ("%p".equals(portConfig = matcher.group(2))) {
            int port = hostConfig.getPort();
            if (port <= 0) {
                port = 22;
            }
            forwardingPort = port;
        } else {
            forwardingPort = Integer.parseInt(portConfig);
        }
        String jumpHost = matcher.group(3);
        return new SshProxyConfig(forwardingPort, forwardingHost, jumpHost);
    }

    public static SshProxyConfig parseProxyJump(String proxyJumpConfig, String sshTunnelHost, ConfigRepository.Config hostConfig) {
        int forwardingPort;
        log.debug("[{}] emulating proxy jump: {}", (Object)sshTunnelHost, (Object)proxyJumpConfig);
        String forwardingHost = hostConfig.getHostname();
        if (forwardingHost == null) {
            forwardingHost = sshTunnelHost;
        }
        if ((forwardingPort = hostConfig.getPort()) <= 0) {
            forwardingPort = 22;
        }
        String jumpHost = proxyJumpConfig;
        return new SshProxyConfig(forwardingPort, forwardingHost, jumpHost);
    }

    public int getForwardingPort() {
        return this.forwardingPort;
    }

    public String getForwardingHost() {
        return this.forwardingHost;
    }

    public String getJumpHost() {
        return this.jumpHost;
    }
}

