/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.proxy.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.cronn.proxy.ssh.SshConfiguration;
import de.cronn.proxy.ssh.SshProxyConfig;
import de.cronn.proxy.ssh.util.Assert;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshProxy
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SshProxy.class);
    public static final String LOCALHOST = "localhost";
    private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    private final Deque<Session> sshSessions = new ArrayDeque<Session>();
    private final Map<Session, Set<Integer>> portForwardings = new LinkedHashMap<Session, Set<Integer>>();
    private final SshConfiguration sshConfiguration;
    private int timeoutMillis;

    public SshProxy() {
        this(10000);
    }

    public SshProxy(int timeoutMillis) {
        try {
            this.sshConfiguration = SshConfiguration.getConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to open SSH proxy", e);
        }
        this.timeoutMillis = timeoutMillis;
    }

    public int connect(String sshTunnelHost, String host, int port) {
        return this.connect(sshTunnelHost, host, port, 0);
    }

    public int connect(String sshTunnelHost, String host, int port, int localPort) {
        Assert.notNull(sshTunnelHost, "sshTunnelHost must not be null");
        Assert.notNull(host, "host must not be null");
        Assert.isTrue(port > 0, "illegal port: " + port);
        Assert.isTrue(localPort >= 0, "illegal local port: " + localPort);
        log.debug("tunneling to {}:{} via {}", new Object[]{host, port, sshTunnelHost});
        try {
            this.sshConfiguration.addIdentity(sshTunnelHost);
            SshProxyConfig proxyConfig = this.sshConfiguration.getProxyConfiguration(sshTunnelHost);
            if (proxyConfig == null) {
                return this.directConnect(sshTunnelHost, host, port, localPort);
            }
            int jumpPort = this.connect(proxyConfig);
            String hostUser = this.sshConfiguration.getHostUser(sshTunnelHost);
            String jumpHost = proxyConfig.getJumpHost();
            Session jumpHostSession = this.sshConfiguration.openSession(hostUser, jumpHost, jumpPort);
            String hostname = this.sshConfiguration.getHostName(sshTunnelHost);
            jumpHostSession.setHostKeyAlias(hostname);
            this.sshSessions.push(jumpHostSession);
            jumpHostSession.setTimeout(this.timeoutMillis);
            jumpHostSession.connect(this.timeoutMillis);
            log.debug("[{}] connected via {}@localhost:{}", new Object[]{sshTunnelHost, hostUser, jumpPort});
            return this.addLocalPortForwarding(sshTunnelHost, jumpHostSession, host, port, localPort);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SSH tunnel to " + host + " via " + sshTunnelHost, e);
        }
    }

    private int connect(SshProxyConfig proxyConfig) {
        String jumpHost = proxyConfig.getJumpHost();
        String forwardingHost = proxyConfig.getForwardingHost();
        int forwardingPort = proxyConfig.getForwardingPort();
        return this.connect(jumpHost, forwardingHost, forwardingPort);
    }

    private int directConnect(String jumpHost, String targetHost, int targetPort, int localPort) throws JSchException {
        Session jumpHostSession = this.sshConfiguration.openSession(jumpHost);
        this.sshSessions.add(jumpHostSession);
        jumpHostSession.setTimeout(this.timeoutMillis);
        try {
            jumpHostSession.connect(this.timeoutMillis);
        }
        catch (JSchException e) {
            log.debug("Failed to connect to {} via {}", new Object[]{targetHost, jumpHost, e});
            throw new RuntimeException("Failed to connect to " + targetHost + " via " + jumpHost);
        }
        log.debug("[{}] connected", (Object)jumpHost);
        return this.addLocalPortForwarding(jumpHost, jumpHostSession, targetHost, targetPort, localPort);
    }

    private int addLocalPortForwarding(String sshTunnelHost, Session session, String targetHost, int targetPort, int localPort) throws JSchException {
        int localPortReturned = session.setPortForwardingL(localPort, targetHost, targetPort);
        log.debug("[{}] local port {} forwarded to {}:{}", new Object[]{sshTunnelHost, localPortReturned, targetHost, targetPort});
        Set<Integer> ports = this.portForwardings.get(session);
        if (ports == null) {
            ports = new LinkedHashSet<Integer>();
            this.portForwardings.put(session, ports);
        }
        ports.add(localPortReturned);
        return localPortReturned;
    }

    @Override
    public void close() {
        if (!this.sshSessions.isEmpty()) {
            log.debug("closing SSH sessions");
        }
        while (!this.sshSessions.isEmpty()) {
            Session session = this.sshSessions.pop();
            this.deletePortForwarding(session);
            try {
                session.disconnect();
            }
            catch (Exception e) {
                log.error("Failed to disconnect SSH session", (Throwable)e);
            }
        }
        Assert.isTrue(this.portForwardings.isEmpty(), "port forwardings must be empty at this point");
    }

    private void deletePortForwarding(Session session) {
        Set<Integer> ports = this.portForwardings.remove(session);
        if (ports != null) {
            for (Integer localPort : ports) {
                try {
                    String host = session.getHost();
                    if (host.equals(LOCALHOST)) {
                        host = session.getHostKeyAlias();
                    }
                    session.delPortForwardingL(LOCALHOST, localPort.intValue());
                    log.debug("deleted local port forwarding on port {} for {}", (Object)localPort, (Object)host);
                }
                catch (Exception e) {
                    log.error("failed to delete port forwarding of port {}", (Object)localPort, (Object)e);
                }
            }
        }
    }
}

