/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.proxy.ssh;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import de.cronn.proxy.ssh.HostKeyType;
import de.cronn.proxy.ssh.JSchHelper;
import de.cronn.proxy.ssh.SshProxyConfig;
import de.cronn.proxy.ssh.util.Assert;
import de.cronn.proxy.ssh.util.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SshConfiguration.class);
    private static final String SSH_CONFIG_KEY_IDENTITY_FILE = "IdentityFile";
    private static final String SSH_CONFIG_KEY_PROXY_COMMAND = "ProxyCommand";
    private static final String SSH_CONFIG_KEY_PROXY_JUMP = "ProxyJump";
    private static final String USER_NAME = System.getProperty("user.name");
    protected static final int SSH_DEFAULT_PORT = 22;
    private final JSch jsch = new JSch();
    private final ConfigRepository configRepository;

    public SshConfiguration(ConfigRepository configRepository) throws JSchException {
        JSchHelper.configureGlobalSettings();
        this.configRepository = configRepository;
        this.jsch.setConfigRepository(this.configRepository);
        Assert.isTrue(Files.isRegularFile(SshConfiguration.getLocalSshKnownHostsPath(), new LinkOption[0]), SshConfiguration.getLocalSshKnownHostsPath() + " does not exist");
        this.jsch.setKnownHosts(SshConfiguration.getLocalSshKnownHostsPath().toString());
    }

    public static SshConfiguration getConfiguration() throws IOException, JSchException {
        Assert.isTrue(Files.isRegularFile(SshConfiguration.getLocalSshConfigPath(), new LinkOption[0]), SshConfiguration.getLocalSshConfigPath() + " does not exist");
        return new SshConfiguration((ConfigRepository)OpenSSHConfig.parseFile((String)SshConfiguration.getLocalSshConfigPath().toString()));
    }

    private static String getUserHome() {
        return System.getProperty("user.home");
    }

    private static Path getSshHome() {
        return Paths.get(SshConfiguration.getUserHome(), ".ssh");
    }

    public static Path getLocalSshConfigPath() {
        return SshConfiguration.getSshHome().resolve("config");
    }

    private static Path getLocalSshKnownHostsPath() {
        return SshConfiguration.getSshHome().resolve("known_hosts");
    }

    private static Path getDefaultSshKeyPath() {
        return SshConfiguration.getSshHome().resolve("id_rsa");
    }

    private ConfigRepository.Config getHostConfig(String host) {
        return this.configRepository.getConfig(host);
    }

    public SshProxyConfig getProxyConfiguration(String host) {
        ConfigRepository.Config config = this.getHostConfig(host);
        String sshProxyCommand = config.getValue(SSH_CONFIG_KEY_PROXY_COMMAND);
        if (sshProxyCommand != null) {
            return SshProxyConfig.parseProxyCommand(sshProxyCommand, host, config);
        }
        String sshProxyJump = config.getValue(SSH_CONFIG_KEY_PROXY_JUMP);
        if (sshProxyJump != null) {
            return SshProxyConfig.parseProxyJump(sshProxyJump, host, config);
        }
        return null;
    }

    void addIdentity(String host) throws JSchException {
        ConfigRepository.Config hostConfig = this.getHostConfig(host);
        String identityFile = hostConfig.getValue(SSH_CONFIG_KEY_IDENTITY_FILE);
        if (identityFile == null) {
            identityFile = SshConfiguration.getDefaultSshKeyPath().toString();
        }
        log.debug("using SSH key file {}", (Object)identityFile);
        this.jsch.addIdentity(identityFile);
    }

    public String getHostUser(String host) {
        ConfigRepository.Config hostConfig = this.getHostConfig(host);
        String hostUser = hostConfig.getUser();
        if (hostUser == null) {
            return USER_NAME;
        }
        return hostUser;
    }

    public String getHostName(String host) {
        ConfigRepository.Config hostConfig = this.getHostConfig(host);
        String hostname = hostConfig.getHostname();
        if (hostname == null) {
            return host;
        }
        return hostname;
    }

    private void configureHostKeyOrder(String host) {
        ConfigRepository.Config hostConfig = this.getHostConfig(host);
        JSchHelper.ServerHostKeySortOrder hostKeySortOrder = this.guessPreferredHostKeySortOrder(host, hostConfig);
        JSchHelper.reconfigureServerHostKeyOrder(hostKeySortOrder);
    }

    private JSchHelper.ServerHostKeySortOrder guessPreferredHostKeySortOrder(String jumpHostName, ConfigRepository.Config hostConfig) {
        HostKeyRepository hostKeyRepository = this.jsch.getHostKeyRepository();
        ArrayList<String> potentialHostNames = new ArrayList<String>();
        potentialHostNames.add(jumpHostName);
        String configHostName = hostConfig.getHostname();
        if (configHostName != null) {
            if (hostConfig.getPort() > 0 && hostConfig.getPort() != 22) {
                configHostName = "[" + configHostName + "]:" + hostConfig.getPort();
            }
            potentialHostNames.add(configHostName);
        }
        for (String hostname : potentialHostNames) {
            Object[] hostKeys;
            for (HostKeyType hostKeyType : EnumSet.of(HostKeyType.ECDSA256, HostKeyType.ECDSA384, HostKeyType.ECDSA521)) {
                hostKeys = hostKeyRepository.getHostKey(hostname, hostKeyType.getTypeString());
                if (!Utils.isNotEmpty(hostKeys)) continue;
                return JSchHelper.ServerHostKeySortOrder.PREFER_ECDSA;
            }
            for (HostKeyType hostKeyType : EnumSet.of(HostKeyType.SSH_RSA)) {
                hostKeys = hostKeyRepository.getHostKey(hostname, hostKeyType.getTypeString());
                if (!Utils.isNotEmpty(hostKeys)) continue;
                return JSchHelper.ServerHostKeySortOrder.PREFER_RSA;
            }
        }
        String hostDescription = jumpHostName;
        if (hostConfig.getHostname() != null) {
            hostDescription = hostDescription + " (" + hostConfig.getHostname() + ")";
        }
        throw new IllegalArgumentException("Found no host key for " + hostDescription + " in " + hostKeyRepository.getKnownHostsRepositoryID());
    }

    public Session openSession(String host) throws JSchException {
        this.configureHostKeyOrder(host);
        return this.jsch.getSession(host);
    }

    public Session openSession(String hostUser, String jumpHost, int jumpPort) throws JSchException {
        this.configureHostKeyOrder(jumpHost);
        return this.jsch.getSession(hostUser, "localhost", jumpPort);
    }
}

