/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.proxy.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import de.cronn.proxy.ssh.HostKeyType;
import de.cronn.proxy.ssh.JSchSlf4JLogger;
import de.cronn.proxy.ssh.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class JSchHelper {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(JSchHelper.class);
    private static final String SERVER_HOST_KEY_SEPARATOR = ",";
    private static final String JSCH_CONFIG_KEY_SERVER_HOST_KEY = "server_host_key";
    private static final String JSCH_CONFIG_KEY_PREFERRED_AUTHENTICATIONS = "PreferredAuthentications";
    private static final Comparator<HostKeyType> CMP_PREFER_ECDSA = new HostKeyComparator(HostKeyType.ECDSA256, HostKeyType.ECDSA384, HostKeyType.ECDSA521, HostKeyType.SSH_RSA, HostKeyType.SSH_DSS);
    private static final Comparator<HostKeyType> CMP_PREFER_RSA = new HostKeyComparator(HostKeyType.SSH_RSA, HostKeyType.ECDSA256, HostKeyType.ECDSA384, HostKeyType.ECDSA521, HostKeyType.SSH_DSS);

    private JSchHelper() {
    }

    protected static void reconfigureServerHostKeyOrder(ServerHostKeySortOrder hostKeySortOrder) {
        ArrayList<HostKeyType> serverHostKeys = new ArrayList<HostKeyType>(JSchHelper.getServerHostKeys());
        if (hostKeySortOrder == ServerHostKeySortOrder.PREFER_ECDSA) {
            Collections.sort(serverHostKeys, CMP_PREFER_ECDSA);
        } else if (hostKeySortOrder == ServerHostKeySortOrder.PREFER_RSA) {
            Collections.sort(serverHostKeys, CMP_PREFER_RSA);
        } else {
            throw new IllegalArgumentException("Unknown host key sort order: " + (Object)((Object)hostKeySortOrder));
        }
        if (!JSchHelper.getServerHostKeys().equals(serverHostKeys)) {
            log.debug("changing server host key order to: " + serverHostKeys);
            ArrayList<String> serverHostKeyNames = new ArrayList<String>();
            for (HostKeyType serverHostKey : serverHostKeys) {
                serverHostKeyNames.add(serverHostKey.getTypeString());
            }
            String newHostKeyOrder = Utils.join(serverHostKeyNames, SERVER_HOST_KEY_SEPARATOR);
            JSch.setConfig((String)JSCH_CONFIG_KEY_SERVER_HOST_KEY, (String)newHostKeyOrder);
        }
    }

    protected static void reconfigurePreferredAuthentications() {
        JSch.setConfig((String)JSCH_CONFIG_KEY_PREFERRED_AUTHENTICATIONS, (String)"publickey");
    }

    protected static void registerLogger() {
        JSch.setLogger((Logger)new JSchSlf4JLogger());
    }

    protected static List<HostKeyType> getServerHostKeys() {
        String serverHostKey = JSch.getConfig((String)JSCH_CONFIG_KEY_SERVER_HOST_KEY);
        ArrayList<HostKeyType> hostKeyTypes = new ArrayList<HostKeyType>();
        for (String hostKeyString : Arrays.asList(serverHostKey.split(SERVER_HOST_KEY_SEPARATOR))) {
            hostKeyTypes.add(HostKeyType.byTypeString(hostKeyString));
        }
        return hostKeyTypes;
    }

    public static void configureGlobalSettings() {
        JSchHelper.reconfigurePreferredAuthentications();
        JSchHelper.registerLogger();
    }

    public static enum ServerHostKeySortOrder {
        PREFER_ECDSA,
        PREFER_RSA;

    }

    private static class HostKeyComparator
    implements Comparator<HostKeyType> {
        private final List<HostKeyType> sortOrder;

        protected HostKeyComparator(List<HostKeyType> sortOrder) {
            this.sortOrder = sortOrder;
        }

        protected HostKeyComparator(HostKeyType ... sortOrder) {
            this(Arrays.asList(sortOrder));
        }

        @Override
        public int compare(HostKeyType a, HostKeyType b) {
            int indexA = this.sortOrder.indexOf((Object)a);
            int indexB = this.sortOrder.indexOf((Object)b);
            return Integer.compare(indexA, indexB);
        }
    }
}

