/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.proxy.ssh;

import de.cronn.proxy.ssh.util.Assert;
import java.util.HashMap;
import java.util.Map;

public enum HostKeyType {
    SSH_DSS(1, "ssh-dss"),
    SSH_RSA(2, "ssh-rsa"),
    ECDSA256(3, "ecdsa-sha2-nistp256"),
    ECDSA384(4, "ecdsa-sha2-nistp384"),
    ECDSA521(5, "ecdsa-sha2-nistp521");

    private final int type;
    private final String typeString;
    private static final Map<String, HostKeyType> valuesByTypeString;

    private HostKeyType(int type, String typeString) {
        this.type = type;
        this.typeString = typeString;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public static HostKeyType byTypeString(String typeString) {
        HostKeyType hostKeyType = valuesByTypeString.get(typeString);
        Assert.notNull((Object)hostKeyType, "No hostKeyType found for " + typeString);
        return hostKeyType;
    }

    static {
        valuesByTypeString = new HashMap<String, HostKeyType>();
        for (HostKeyType hostKeyType : HostKeyType.values()) {
            HostKeyType oldValue = valuesByTypeString.put(hostKeyType.getTypeString(), hostKeyType);
            Assert.isNull((Object)oldValue, "Duplicate value for " + hostKeyType.getTypeString());
        }
    }
}

