/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.reflection.util;

import de.cronn.reflection.util.ClassUtils;
import de.cronn.reflection.util.PropertyDescriptorCache;
import de.cronn.reflection.util.ReflectionRuntimeException;
import de.cronn.reflection.util.TypedPropertyGetter;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.objenesis.ObjenesisHelper;

public final class PropertyUtils {
    private static final Map<Class<?>, PropertyDescriptorCache<?>> cache = new ConcurrentHashMap();

    private PropertyUtils() {
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorByName(Object bean, String propertyName) {
        return PropertyUtils.getPropertyDescriptorByName(ClassUtils.getRealClass(bean), propertyName);
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorByName(Class<?> beanClass, String propertyName) {
        PropertyDescriptorCache<?> propertyDescriptorCache = PropertyUtils.getCache(beanClass);
        return propertyDescriptorCache.getDescriptorByName(propertyName);
    }

    @Nonnull
    public static PropertyDescriptor getPropertyDescriptorByNameOrThrow(Object bean, String propertyName) {
        Class<Object> beanClass = ClassUtils.getRealClass(bean);
        return PropertyUtils.getPropertyDescriptorByNameOrThrow(beanClass, propertyName);
    }

    @Nonnull
    public static PropertyDescriptor getPropertyDescriptorByNameOrThrow(Class<?> beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptorByName(beanClass, propertyName);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Property '%s' not found for '%s'", propertyName, beanClass.getSimpleName()));
        }
        return propertyDescriptor;
    }

    public static Collection<PropertyDescriptor> getPropertyDescriptors(Class<?> type) {
        PropertyDescriptorCache<?> propertyDescriptorCache = PropertyUtils.getCache(type);
        return propertyDescriptorCache.getDescriptors();
    }

    public static Collection<PropertyDescriptor> getPropertyDescriptors(Object object) {
        return PropertyUtils.getPropertyDescriptors(ClassUtils.getRealClass(object));
    }

    public static <A extends Annotation> Map<PropertyDescriptor, A> getPropertyDescriptorsWithAnnotation(Object object, Class<A> annotationClass) {
        Class<Object> objectClass = ClassUtils.getRealClass(object);
        return PropertyUtils.getPropertyDescriptorsWithAnnotation(objectClass, annotationClass);
    }

    public static <A extends Annotation> Map<PropertyDescriptor, A> getPropertyDescriptorsWithAnnotation(Class<?> type, Class<A> annotationClass) {
        PropertyDescriptorCache<?> propertyDescriptorCache = PropertyUtils.getCache(type);
        return propertyDescriptorCache.getDescriptorsForAnnotation(annotationClass);
    }

    static <T> PropertyDescriptorCache<T> getCache(Class<T> type) {
        return cache.computeIfAbsent(type, PropertyDescriptorCache::compute);
    }

    public static <T> T copyNonDefaultValues(T source, T destination) {
        PropertyUtils.getPropertyDescriptors(source).stream().filter(PropertyUtils::isFullyAccessible).filter(propertyDescriptor -> !PropertyUtils.hasDefaultValue(source, propertyDescriptor)).forEach(propertyDescriptor -> PropertyUtils.copyValue(source, destination, propertyDescriptor));
        return destination;
    }

    public static <T> Object copyValue(T source, T destination, PropertyDescriptor propertyDescriptor) {
        T value = PropertyUtils.read(source, propertyDescriptor);
        PropertyUtils.write(destination, propertyDescriptor, value);
        return value;
    }

    public static <T> boolean hasDefaultValue(T bean, PropertyDescriptor propertyDescriptor) {
        T value = PropertyUtils.read(bean, propertyDescriptor);
        Class<T> beanClass = ClassUtils.getRealClass(bean);
        return PropertyUtils.isDefaultValue(beanClass, propertyDescriptor, value);
    }

    public static <T> boolean hasSameValue(T a, T b, PropertyDescriptor propertyDescriptor) {
        T valueFromA = PropertyUtils.read(a, propertyDescriptor);
        T valueFromB = PropertyUtils.read(b, propertyDescriptor);
        return Objects.equals(valueFromA, valueFromB);
    }

    public static <T> boolean hasDifferentValue(T a, T b, PropertyDescriptor propertyDescriptor) {
        return !PropertyUtils.hasSameValue(a, b, propertyDescriptor);
    }

    public static <T> boolean isDefaultValue(Class<T> objectClass, TypedPropertyGetter<T, ?> propertyGetter, Object value) {
        return PropertyUtils.isDefaultValue(objectClass, PropertyUtils.getPropertyDescriptor(objectClass, propertyGetter), value);
    }

    public static <T> boolean isDefaultValue(Class<T> objectClass, PropertyDescriptor propertyDescriptor, Object value) {
        Object defaultValue = PropertyUtils.getDefaultValue(objectClass, propertyDescriptor);
        return Objects.equals(value, defaultValue);
    }

    public static <T> Object getDefaultValue(Class<T> objectClass, PropertyDescriptor propertyDescriptor) {
        return PropertyUtils.getCache(objectClass).getDefaultValue(propertyDescriptor);
    }

    public static void write(Object destination, String propertyName, Object value) {
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptorByNameOrThrow(destination, propertyName);
        PropertyUtils.write(destination, propertyDescriptor, value);
    }

    public static <T> void writeIfPropertyExists(Object destination, String propertyName, Supplier<T> valueSupplier) {
        PropertyDescriptor property = PropertyUtils.getPropertyDescriptorByName(destination, propertyName);
        if (property != null) {
            T value = valueSupplier.get();
            PropertyUtils.write(destination, property, value);
        }
    }

    public static void write(Object destination, PropertyDescriptor propertyDescriptor, Object value) {
        PropertyUtils.write(destination, propertyDescriptor, value, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(Object destination, PropertyDescriptor propertyDescriptor, Object value, boolean force) {
        try {
            if (!PropertyUtils.isWritable(propertyDescriptor)) {
                if (!force) throw new IllegalArgumentException(propertyDescriptor.getName() + " is not writable");
                PropertyUtils.writeDirectly(destination, propertyDescriptor, value);
                return;
            } else {
                Object[] args = new Object[]{value};
                Method writeMethod = propertyDescriptor.getWriteMethod();
                writeMethod.invoke(destination, args);
            }
            return;
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ReflectionRuntimeException("Failed to write " + propertyDescriptor.getName() + " to " + destination, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDirectly(Object destination, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            Field field = PropertyUtils.findField(destination, propertyDescriptor);
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(destination, value);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionRuntimeException("Failed to write " + PropertyUtils.getQualifiedPropertyName(destination, propertyDescriptor), e);
        }
    }

    private static Field findField(Object object, PropertyDescriptor propertyDescriptor) throws NoSuchFieldException {
        Class<Object> objectClass = ClassUtils.getRealClass(object);
        return PropertyUtils.findField(objectClass, propertyDescriptor.getName());
    }

    private static Field findField(Class<Object> objectClass, String propertyName) throws NoSuchFieldException {
        try {
            return objectClass.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            Class<Object> superclass = objectClass.getSuperclass();
            if (!superclass.equals(Object.class)) {
                return PropertyUtils.findField(superclass, propertyName);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readDirectly(Object object, PropertyDescriptor propertyDescriptor) {
        try {
            Field field = PropertyUtils.findField(object, propertyDescriptor);
            boolean accessible = field.isAccessible();
            try {
                Object value;
                if (!accessible) {
                    field.setAccessible(true);
                }
                Object object2 = value = field.get(object);
                return (T)object2;
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionRuntimeException("Failed to read " + PropertyUtils.getQualifiedPropertyName(object, propertyDescriptor), e);
        }
    }

    public static <T> T read(Object source, PropertyDescriptor propertyDescriptor) {
        Object result;
        if (!PropertyUtils.isReadable(propertyDescriptor)) {
            throw new IllegalArgumentException(String.format("%s must be readable", propertyDescriptor.getName()));
        }
        try {
            Method readMethod = propertyDescriptor.getReadMethod();
            result = readMethod.invoke(source, new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ReflectionRuntimeException("Failed to read " + PropertyUtils.getQualifiedPropertyName(source, propertyDescriptor), e);
        }
        Object castedResult = result;
        return (T)castedResult;
    }

    public static <T> T readIfPropertyExists(Object source, String propertyName) {
        PropertyDescriptor property = PropertyUtils.getPropertyDescriptorByName(source, propertyName);
        if (property != null) {
            return PropertyUtils.read(source, property);
        }
        return null;
    }

    public static <T> T readProperty(Object entity, PropertyDescriptor propertyDescriptor, Class<T> expectedType) {
        Class<Object> clazz = ClassUtils.getRealClass(entity);
        String propertyName = propertyDescriptor.getName();
        Class<?> propertyType = propertyDescriptor.getPropertyType();
        if (!expectedType.isAssignableFrom(propertyType)) {
            throw new IllegalArgumentException(String.format("%s.%s is of type %s but %s is expected", clazz, propertyName, propertyType, expectedType));
        }
        T value = PropertyUtils.read(entity, propertyDescriptor);
        return value;
    }

    @Nonnull
    public static <T> PropertyDescriptor getPropertyDescriptor(T bean, TypedPropertyGetter<T, ?> propertyGetter) {
        Class<T> beanClass = ClassUtils.getRealClass(bean);
        return PropertyUtils.getPropertyDescriptor(beanClass, propertyGetter);
    }

    @Nonnull
    public static <T> PropertyDescriptor getPropertyDescriptor(Class<T> beanClass, TypedPropertyGetter<T, ?> propertyGetter) {
        Method method = PropertyUtils.getMethod(beanClass, propertyGetter);
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptorByMethod(beanClass, method);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Found no property for %s on class %s", method, beanClass));
        }
        return propertyDescriptor;
    }

    @Nonnull
    public static <T> String getPropertyName(Class<T> beanClass, TypedPropertyGetter<T, ?> propertyGetter) {
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(beanClass, propertyGetter);
        return propertyDescriptor.getName();
    }

    @Nonnull
    public static <T> String getPropertyName(T bean, TypedPropertyGetter<T, ?> propertyGetter) {
        Class<T> beanClass = ClassUtils.getRealClass(bean);
        return PropertyUtils.getPropertyName(beanClass, propertyGetter);
    }

    @Nullable
    public static <T> PropertyDescriptor getPropertyDescriptorByMethod(Class<T> beanClass, Method method) {
        PropertyDescriptorCache<T> propertyDescriptorCache = PropertyUtils.getCache(beanClass);
        return propertyDescriptorCache.getDescriptorByMethod(method);
    }

    @Nullable
    public static <T> PropertyDescriptor getPropertyDescriptorByField(Class<T> beanClass, Field field) {
        PropertyDescriptorCache<T> propertyDescriptorCache = PropertyUtils.getCache(beanClass);
        return propertyDescriptorCache.getDescriptorByField(field);
    }

    @Nonnull
    public static <T> Method getMethod(Class<T> beanClass, TypedPropertyGetter<T, ?> propertyGetter) {
        PropertyDescriptorCache<T> cache = PropertyUtils.getCache(beanClass);
        return cache.getMethod(propertyGetter);
    }

    static <T> Method findMethodByGetter(Class<T> beanClass, TypedPropertyGetter<T, ?> propertyGetter) {
        MethodCaptor methodCaptor = new MethodCaptor();
        T proxy = PropertyUtils.createProxy(beanClass, methodCaptor);
        propertyGetter.get(proxy);
        return methodCaptor.getCapturedMethod();
    }

    private static <T> T createProxy(Class<T> beanClass, InvocationHandler invocationHandler) {
        Class proxyClass = new ByteBuddy().subclass(beanClass, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).method((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)))).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)invocationHandler)).make().load(PropertyUtils.class.getClassLoader()).getLoaded();
        return (T)ObjenesisHelper.newInstance((Class)proxyClass);
    }

    public static boolean hasAnnotationOfProperty(Class<?> entityType, PropertyDescriptor descriptor, Class<? extends Annotation> annotationClass) {
        return PropertyUtils.getAnnotationOfProperty(entityType, descriptor, annotationClass) != null;
    }

    public static <T, A extends Annotation> A getAnnotationOfProperty(Class<T> entityType, TypedPropertyGetter<T, ?> propertyGetter, Class<A> annotationClass) {
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(entityType, propertyGetter);
        return PropertyUtils.getAnnotationOfProperty(entityType, propertyDescriptor, annotationClass);
    }

    public static <A extends Annotation> A getAnnotationOfProperty(Object object, PropertyDescriptor descriptor, Class<A> annotationClass) {
        Class<Object> objectClass = ClassUtils.getRealClass(object);
        return PropertyUtils.getAnnotationOfProperty(objectClass, descriptor, annotationClass);
    }

    public static <A extends Annotation> A getAnnotationOfProperty(Class<?> entityType, PropertyDescriptor descriptor, Class<A> annotationClass) {
        PropertyDescriptorCache<?> cache = PropertyUtils.getCache(entityType);
        Map<PropertyDescriptor, A> descriptorsForAnnotation = cache.getDescriptorsForAnnotation(annotationClass);
        return (A)((Annotation)descriptorsForAnnotation.get(descriptor));
    }

    public static boolean isFullyAccessible(PropertyDescriptor descriptor) {
        return PropertyUtils.isReadable(descriptor) && PropertyUtils.isWritable(descriptor);
    }

    public static boolean isWritable(PropertyDescriptor descriptor) {
        return descriptor.getWriteMethod() != null;
    }

    public static boolean isReadable(PropertyDescriptor descriptor) {
        return descriptor.getReadMethod() != null;
    }

    public static boolean isDeclaredInClass(PropertyDescriptor propertyDescriptor, Class<?> entityClass) {
        Method readMethod = propertyDescriptor.getReadMethod();
        return readMethod != null && Objects.equals(readMethod.getDeclaringClass(), entityClass);
    }

    public static boolean hasProperty(Object bean, String propertyName) {
        return PropertyUtils.getPropertyDescriptorByName(bean, propertyName) != null;
    }

    public static boolean hasProperty(Class<?> beanClass, String propertyName) {
        return PropertyUtils.getPropertyDescriptorByName(beanClass, propertyName) != null;
    }

    public static Object getDefaultValueObject(Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Long.TYPE)) {
                return 0L;
            }
            if (type.equals(Integer.TYPE)) {
                return 0;
            }
            if (type.equals(Boolean.TYPE)) {
                return false;
            }
            if (type.equals(Void.TYPE)) {
                return null;
            }
            throw new IllegalArgumentException("Unhandled primitive type: " + type);
        }
        return null;
    }

    public static <T> String getQualifiedPropertyName(T bean, TypedPropertyGetter<T, ?> propertyGetter) {
        Class<T> beanClass = ClassUtils.getRealClass(bean);
        return PropertyUtils.getQualifiedPropertyName(beanClass, propertyGetter);
    }

    public static <T> String getQualifiedPropertyName(Class<T> type, TypedPropertyGetter<T, ?> propertyGetter) {
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(type, propertyGetter);
        return PropertyUtils.getQualifiedPropertyName(type, propertyDescriptor);
    }

    public static String getQualifiedPropertyName(Object bean, PropertyDescriptor propertyDescriptor) {
        return PropertyUtils.getQualifiedPropertyName(ClassUtils.getRealClass(bean), propertyDescriptor);
    }

    public static String getQualifiedPropertyName(Class<?> type, PropertyDescriptor propertyDescriptor) {
        return type.getSimpleName() + "." + propertyDescriptor.getName();
    }

    public static boolean isCollectionType(PropertyDescriptor propertyDescriptor) {
        return Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType());
    }

    public static boolean isNotCollectionType(PropertyDescriptor propertyDescriptor) {
        return !PropertyUtils.isCollectionType(propertyDescriptor);
    }

    private static class MethodCaptor
    implements InvocationHandler {
        private final AtomicReference<Method> capturedMethod = new AtomicReference();

        private MethodCaptor() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method existing = this.capturedMethod.getAndSet(method);
            if (existing != null) {
                throw new IllegalArgumentException(String.format("Method already captured: %s called twice?", existing));
            }
            return PropertyUtils.getDefaultValueObject(method.getReturnType());
        }

        Method getCapturedMethod() {
            Method method = this.capturedMethod.get();
            if (method == null) {
                throw new IllegalArgumentException("Method could not be captured. This can happen when no method was invoked or the method is private or final.");
            }
            return method;
        }
    }
}

