/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.reflection.util;

import de.cronn.reflection.util.ClassUtils;
import de.cronn.reflection.util.PropertyGetter;
import de.cronn.reflection.util.PropertyUtils;
import de.cronn.reflection.util.ReflectionRuntimeException;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyDescriptorCache<T> {
    private static final Logger log = LoggerFactory.getLogger(PropertyDescriptorCache.class);
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> propertyDescriptorsByName = new LinkedHashMap<String, PropertyDescriptor>();
    private final Map<Field, PropertyDescriptor> propertyDescriptorsByField = new LinkedHashMap<Field, PropertyDescriptor>();
    private final Map<Method, PropertyDescriptor> propertyDescriptorsByMethod = new LinkedHashMap<Method, PropertyDescriptor>();
    private final Map<Class<? extends Annotation>, Map<PropertyDescriptor, Annotation>> propertyDescriptorsByAnnotation = new LinkedHashMap<Class<? extends Annotation>, Map<PropertyDescriptor, Annotation>>();
    private final Map<PropertyGetter<T>, Method> methodByPropertyGetterCache = new ConcurrentHashMap<PropertyGetter<T>, Method>();
    private final Map<PropertyDescriptor, Object> defaultValues = new ConcurrentHashMap<PropertyDescriptor, Object>();

    private PropertyDescriptorCache(Class<T> type) {
        this.type = type;
        for (PropertyDescriptor propertyDescriptor : this.getAllPropertyDescriptors()) {
            Method writeMethod;
            this.propertyDescriptorsByName.put(propertyDescriptor.getName(), propertyDescriptor);
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                this.propertyDescriptorsByMethod.put(readMethod, propertyDescriptor);
                this.putAnnotations(propertyDescriptor, readMethod.getAnnotations());
            }
            if ((writeMethod = propertyDescriptor.getWriteMethod()) == null) continue;
            this.propertyDescriptorsByMethod.put(writeMethod, propertyDescriptor);
            this.putAnnotations(propertyDescriptor, writeMethod.getAnnotations());
        }
        for (Field field : this.getFields()) {
            PropertyDescriptor propertyDescriptor = this.propertyDescriptorsByName.get(field.getName());
            if (propertyDescriptor == null) continue;
            this.propertyDescriptorsByField.put(field, propertyDescriptor);
            this.putAnnotations(propertyDescriptor, field.getAnnotations());
        }
    }

    private Set<Field> getFields() {
        ArrayList<Field> allFields = new ArrayList<Field>();
        PropertyDescriptorCache.collectFields(this.type, allFields);
        allFields.sort(Comparator.comparing(Field::getName));
        return new LinkedHashSet<Field>(allFields);
    }

    private static void collectFields(Class<?> type, Collection<Field> collectedFields) {
        Class<?> superclass;
        collectedFields.addAll(Arrays.asList(type.getFields()));
        collectedFields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (!type.equals(Object.class) && (superclass = type.getSuperclass()) != null) {
            PropertyDescriptorCache.collectFields(superclass, collectedFields);
        }
    }

    private void putAnnotations(PropertyDescriptor propertyDescriptor, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            this.propertyDescriptorsByAnnotation.computeIfAbsent(annotation.annotationType(), k -> new LinkedHashMap()).put(propertyDescriptor, annotation);
        }
    }

    private PropertyDescriptor[] getAllPropertyDescriptors() {
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(this.type).getPropertyDescriptors();
            descriptors = Arrays.copyOf(descriptors, descriptors.length);
            Arrays.sort(descriptors, Comparator.comparing(FeatureDescriptor::getName));
            return descriptors;
        }
        catch (IntrospectionException e) {
            throw new ReflectionRuntimeException(e);
        }
    }

    Collection<PropertyDescriptor> getDescriptors() {
        return this.propertyDescriptorsByName.values();
    }

    PropertyDescriptor getDescriptorByMethod(Method method) {
        return this.propertyDescriptorsByMethod.get(method);
    }

    PropertyDescriptor getDescriptorByField(Field field) {
        return this.propertyDescriptorsByField.get(field);
    }

    <A extends Annotation> Map<PropertyDescriptor, A> getDescriptorsForAnnotation(Class<A> annotationClass) {
        Map descriptors = this.propertyDescriptorsByAnnotation.getOrDefault(annotationClass, Collections.emptyMap());
        return Collections.unmodifiableMap(descriptors);
    }

    static <T> PropertyDescriptorCache<T> compute(Class<T> type) {
        return new PropertyDescriptorCache<T>(type);
    }

    PropertyDescriptor getDescriptorByName(String propertyName) {
        return this.propertyDescriptorsByName.get(propertyName);
    }

    Object getDefaultValue(PropertyDescriptor propertyDescriptor) {
        return this.defaultValues.computeIfAbsent(propertyDescriptor, this::determineDefaultValue);
    }

    private Object determineDefaultValue(PropertyDescriptor propertyDescriptor) {
        try {
            T defaultObject = ClassUtils.createNewInstance(this.type);
            return PropertyUtils.read(defaultObject, propertyDescriptor);
        }
        catch (RuntimeException e) {
            throw new ReflectionRuntimeException("Failed to determine default value for " + PropertyUtils.getQualifiedPropertyName(this.type, propertyDescriptor), e);
        }
    }

    Method getMethod(PropertyGetter<T> propertyGetter) {
        int methodsInClass;
        int maxExpectedOccurrencesPerProperty;
        int propertyGetterCacheSize = this.methodByPropertyGetterCache.size();
        if (propertyGetterCacheSize > (maxExpectedOccurrencesPerProperty = 100) * (methodsInClass = this.type.getMethods().length)) {
            log.warn("Unexpected number of cached property getters: {} for class {} with {} methods. This indicates a misuse of the PropertyUtils class. Clearing.", new Object[]{propertyGetterCacheSize, this.type.getSimpleName(), methodsInClass});
            this.methodByPropertyGetterCache.clear();
        }
        return this.methodByPropertyGetterCache.computeIfAbsent(propertyGetter, getter -> PropertyUtils.findMethodByGetter(this.type, getter));
    }
}

