/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.postgres.snapshot.util;

import de.cronn.postgres.snapshot.util.ConnectionInformation;
import de.cronn.postgres.snapshot.util.PostgresRestoreOption;
import de.cronn.postgres.snapshot.util.PostgresUtils;
import de.cronn.postgres.snapshot.util.Schema;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.MountableFile;

public final class PostgresRestore {
    private static final Logger log = LoggerFactory.getLogger(PostgresRestore.class);
    private static final String RESTORE_FILE = "/tmp/pg_restore.data";

    private PostgresRestore() {
    }

    public static void restoreFromFile(Path fileToRestore, String jdbcUrl, String username, String password, PostgresRestoreOption ... options) {
        PostgresRestore.restoreFromFile(fileToRestore, jdbcUrl, username, password, List.of(), options);
    }

    public static void restoreFromFile(Path fileToRestore, String jdbcUrl, String username, String password, List<Schema> schemas, PostgresRestoreOption ... options) {
        try (GenericContainer container = PostgresRestore.createPgRestoreInContainer(jdbcUrl, username, password, schemas, options).withCopyFileToContainer(MountableFile.forHostPath((Path)fileToRestore), RESTORE_FILE);){
            container.start();
        }
    }

    private static GenericContainer<?> createPgRestoreInContainer(String jdbcUrl, String username, String password, List<Schema> schemas, PostgresRestoreOption ... options) {
        ConnectionInformation connectionInformation = PostgresUtils.parseConnectionInformation(jdbcUrl, username, password);
        CharSequence[] command = PostgresRestore.createPgRestoreCommand(connectionInformation, schemas, options);
        log.debug("Executing {}", (Object)String.join((CharSequence)" ", command));
        Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(log).withSeparateOutputStreams();
        return PostgresUtils.createPostgresContainer(connectionInformation.postgresVersion()).withNetworkMode(PostgresUtils.deriveNetworkMode(connectionInformation)).withEnv("PGPASSWORD", connectionInformation.password()).withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy()).withCommand((String[])command).withLogConsumer((Consumer)logConsumer);
    }

    private static String[] createPgRestoreCommand(ConnectionInformation connectionInformation, List<Schema> schemas, PostgresRestoreOption ... options) {
        ArrayList<CallSite> commandArgs = new ArrayList<CallSite>(List.of("pg_restore", "--host=" + connectionInformation.host(), "--username=" + connectionInformation.username(), "--dbname=" + connectionInformation.databaseName()));
        if (connectionInformation.port() > 0) {
            commandArgs.add(2, (CallSite)((Object)("--port=" + connectionInformation.port())));
        }
        for (Schema schema : schemas) {
            commandArgs.addAll(schema.getCommandArguments());
        }
        for (PostgresRestoreOption option : options) {
            commandArgs.add((CallSite)((Object)option.getCommandArgument()));
        }
        commandArgs.add((CallSite)((Object)RESTORE_FILE));
        return (String[])commandArgs.toArray(String[]::new);
    }
}

