/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.ext.postgres.diff;

import de.cronn.liquibase.ext.postgres.diff.PostgresEnumType;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Stream;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import org.intellij.lang.annotations.Language;

public class PostgresEnumTypeSnapshotGenerator
extends JdbcSnapshotGenerator {
    @Language(value="PostgreSQL")
    private static final String COLLECT_ENUMS_QUERY = "select t.typname as name, array_agg(distinct e.enumlabel) as values\nfrom pg_enum e\njoin pg_type t on t.oid = e.enumtypid\njoin pg_namespace ns on t.typnamespace = ns.oid and ns.nspname = '%s'\ngroup by t.typname\norder by t.typname";

    public PostgresEnumTypeSnapshotGenerator() {
        super(PostgresEnumType.class, new Class[]{Schema.class});
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) {
        return example;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(PostgresEnumType.class)) {
            return;
        }
        DatabaseConnection databaseConnection = snapshot.getDatabase().getConnection();
        if (databaseConnection instanceof JdbcConnection) {
            JdbcConnection jdbcConnection = (JdbcConnection)databaseConnection;
            Schema schema = foundObject.getSchema();
            String schemaName = schema.getName();
            try (Statement statement = jdbcConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery(COLLECT_ENUMS_QUERY.formatted(schemaName));){
                while (resultSet.next()) {
                    String typeName = resultSet.getString("name");
                    List<String> values = PostgresEnumTypeSnapshotGenerator.collectValues(resultSet.getArray("values"));
                    PostgresEnumType postgresEnumType = new PostgresEnumType();
                    postgresEnumType.setSchema(schema);
                    postgresEnumType.setName(typeName);
                    postgresEnumType.setValues(values);
                    schema.addDatabaseObject((DatabaseObject)postgresEnumType);
                }
            }
            catch (SQLException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    private static List<String> collectValues(Array array) throws SQLException {
        String[] values = (String[])array.getArray();
        return Stream.of(values).sorted().toList();
    }
}

