/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.ext.postgres;

import de.cronn.liquibase.ext.postgres.AbstractPostgresEnumChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

@DatabaseChange(name="renamePostgresEnumValue", description="Renames an enum value of an existing Postgres enum type", priority=1)
public class RenamePostgresEnumValueChange
extends AbstractPostgresEnumChange {
    private String enumTypeName;
    private String oldValue;
    private String newValue;

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = super.validate(database);
        validationErrors.checkRequiredField("enumTypeName", (Object)this.enumTypeName);
        validationErrors.checkRequiredField("oldValue", (Object)this.oldValue);
        validationErrors.checkRequiredField("newValue", (Object)this.newValue);
        return validationErrors;
    }

    @DatabaseChangeProperty(description="The name of the enum type", exampleValue="color")
    public String getEnumTypeName() {
        return this.enumTypeName;
    }

    public void setEnumTypeName(String enumTypeName) {
        this.enumTypeName = enumTypeName;
    }

    @DatabaseChangeProperty(description="The old value of the enum type", exampleValue="REED")
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @DatabaseChangeProperty(description="The new value of the enum type", exampleValue="RED")
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public String getConfirmationMessage() {
        return "Renamed value of enum type %s from %s to %s".formatted(this.getEnumTypeName(), this.getOldValue(), this.getNewValue());
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RawSqlStatement("alter type %s rename value '%s' to '%s'".formatted(this.enumTypeName, this.oldValue, this.newValue))};
    }
}

