/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.ext.postgres;

import de.cronn.liquibase.ext.postgres.AbstractPostgresEnumChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

@DatabaseChange(name="renamePostgresEnumType", description="Renames a Postgres enum type", priority=1)
public class RenamePostgresEnumTypeChange
extends AbstractPostgresEnumChange {
    private String oldName;
    private String newName;

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = super.validate(database);
        validationErrors.checkRequiredField("oldName", (Object)this.oldName);
        validationErrors.checkRequiredField("newName", (Object)this.newName);
        return validationErrors;
    }

    @DatabaseChangeProperty(description="The old name of the enum type", exampleValue="colour")
    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    @DatabaseChangeProperty(description="The new name of the enum type", exampleValue="color")
    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getConfirmationMessage() {
        return "Renamed enum type from %s to %s".formatted(this.getOldName(), this.getNewName());
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RawSqlStatement("alter type %s rename to %s".formatted(this.oldName, this.newName))};
    }
}

