/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.ext.postgres;

import de.cronn.liquibase.ext.postgres.AbstractPostgresEnumChange;
import de.cronn.liquibase.ext.postgres.CreatePostgresEnumTypeChange;
import de.cronn.liquibase.ext.postgres.DropPostgresEnumTypeChange;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.intellij.lang.annotations.Language;

@DatabaseChange(name="modifyPostgresEnumType", description="Modifies the values of an existing Postgres enum type", priority=1)
public class ModifyPostgresEnumTypeChange
extends AbstractPostgresEnumChange {
    @Language(value="PostgreSQL")
    private static final String SELECT_ALL_ENUM_USAGES_QUERY = "SELECT c.relname AS table_name, a.attname AS column_name\nFROM pg_attribute a\nJOIN pg_class c ON a.attrelid = c.oid\nJOIN pg_namespace n ON c.relnamespace = n.oid AND n.nspname = '%s'\nWHERE a.atttypid = (SELECT oid FROM pg_type WHERE typname = '%s')\n  AND c.relkind = 'r'\n  AND NOT a.attisdropped\nORDER BY table_name, column_name";
    private String name;
    private List<String> newValues = new ArrayList<String>();

    public ModifyPostgresEnumTypeChange() {
    }

    public ModifyPostgresEnumTypeChange(String name, List<String> newValues) {
        this.name = name;
        this.newValues = newValues;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = super.validate(database);
        validationErrors.checkRequiredField("name", (Object)this.name);
        validationErrors.checkRequiredField("newValues", this.newValues);
        return validationErrors;
    }

    @DatabaseChangeProperty(description="The name of the enum type", exampleValue="color")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @DatabaseChangeProperty(description="The comma-separated list of new values of the enum type", exampleValue="red, green, blue")
    public String getNewValues() {
        return String.join((CharSequence)", ", this.newValues);
    }

    public void setNewValues(String newValues) {
        this.newValues = ModifyPostgresEnumTypeChange.splitListOfValues(newValues);
    }

    public String getConfirmationMessage() {
        return "Modified values of enum type %s".formatted(this.getName());
    }

    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<Object> statements = new ArrayList<Object>();
        String temporaryName = this.getName() + "_old";
        statements.add(new RawSqlStatement("alter type %s rename to %s".formatted(this.getName(), temporaryName)));
        CreatePostgresEnumTypeChange createPostgresEnumTypeChange = new CreatePostgresEnumTypeChange(this.getName(), this.newValues);
        statements.addAll(Arrays.asList(createPostgresEnumTypeChange.generateStatements(database)));
        JdbcConnection jdbcConnection = (JdbcConnection)database.getConnection();
        String defaultSchemaName = database.getDefaultSchemaName();
        try (Statement statement = jdbcConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(SELECT_ALL_ENUM_USAGES_QUERY.formatted(defaultSchemaName, this.getName()));){
            while (resultSet.next()) {
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                statements.add(new RawSqlStatement("alter table %s alter column %s type %s using %s::text::%s".formatted(tableName, columnName, this.getName(), columnName, this.getName())));
            }
        }
        catch (SQLException | DatabaseException e) {
            throw new RuntimeException(e);
        }
        DropPostgresEnumTypeChange dropPostgresEnumTypeChange = new DropPostgresEnumTypeChange(temporaryName);
        statements.addAll(Arrays.asList(dropPostgresEnumTypeChange.generateStatements(database)));
        return (SqlStatement[])statements.toArray(SqlStatement[]::new);
    }
}

