/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.ext.postgres;

import de.cronn.liquibase.ext.postgres.AbstractPostgresEnumChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

@DatabaseChange(name="dropPostgresEnumType", description="Drops a Postgres enum type", priority=1)
public class DropPostgresEnumTypeChange
extends AbstractPostgresEnumChange {
    private String name;

    public DropPostgresEnumTypeChange() {
    }

    public DropPostgresEnumTypeChange(String name) {
        this.name = name;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = super.validate(database);
        validationErrors.checkRequiredField("name", (Object)this.name);
        return validationErrors;
    }

    public void setName(String name) {
        this.name = name;
    }

    @DatabaseChangeProperty(description="The name of the enum type", exampleValue="color")
    public String getName() {
        return this.name;
    }

    public String getConfirmationMessage() {
        return "Dropped enum type %s".formatted(this.getName());
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RawSqlStatement("drop cast (varchar as %s)".formatted(this.name)), new RawSqlStatement("drop cast (%s as varchar)".formatted(this.name)), new RawSqlStatement("drop type %s".formatted(this.name))};
    }
}

