/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.changelog.generator;

import de.cronn.liquibase.changelog.generator.AbstractHibernatePopulatedConfig;
import de.cronn.liquibase.changelog.generator.AbstractLiquibasePopulatedConfig;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class HibernateToLiquibaseDiff {
    private final String changeSetAuthor;

    protected HibernateToLiquibaseDiff(String changeSetAuthor) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        this.changeSetAuthor = changeSetAuthor;
    }

    /*
     * Exception decompiling
     */
    public String generateDiff(Class<? extends AbstractHibernatePopulatedConfig> hibernatePopulatedConfigClass, Class<? extends AbstractLiquibasePopulatedConfig> liquibasePopulatedConfigClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Connection getConnection(ConfigurableApplicationContext context) throws Exception {
        return ((DataSource)context.getBean(DataSource.class)).getConnection();
    }

    protected DiffResult generateDiff(Connection reference, Connection target) throws Exception {
        Database referenceDatabase = this.newDatabase(reference);
        Database targetDatabase = this.newDatabase(target);
        DiffResult diff = DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, CompareControl.STANDARD);
        return this.filterDiffResult(diff);
    }

    protected DiffResult filterDiffResult(DiffResult diffResult) {
        DatabaseSnapshot referenceDatabaseSnapshot = diffResult.getReferenceSnapshot();
        DatabaseSnapshot comparisonDatabaseSnapshot = diffResult.getComparisonSnapshot();
        CompareControl compareControl = diffResult.getCompareControl();
        DiffResult result = new DiffResult(referenceDatabaseSnapshot, comparisonDatabaseSnapshot, compareControl);
        diffResult.getChangedObjects().forEach((obj, differences) -> this.handleChangedObject(result, (DatabaseObject)obj, (ObjectDifferences)differences));
        for (DatabaseObject obj2 : diffResult.getMissingObjects()) {
            this.handleMissingObject(result, obj2);
        }
        for (DatabaseObject obj2 : diffResult.getUnexpectedObjects()) {
            this.handleUnexpectedObject(result, obj2);
        }
        return result;
    }

    protected void handleChangedObject(DiffResult result, DatabaseObject obj, ObjectDifferences differences) {
        result.addChangedObject(obj, differences);
    }

    protected void handleMissingObject(DiffResult result, DatabaseObject obj) {
        this.generateNewKeyAndIndexNames(obj);
        result.addMissingObject(obj);
    }

    protected void generateNewKeyAndIndexNames(DatabaseObject obj) {
        if (obj instanceof PrimaryKey) {
            PrimaryKey primaryKey = (PrimaryKey)obj;
            primaryKey.setName(this.generateNewPrimaryKeyName(primaryKey));
        }
        if (obj instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)obj;
            foreignKey.setName(this.generateNewForeignKeyName(foreignKey));
        }
        if (obj instanceof Index) {
            Index index = (Index)obj;
            index.setName(this.generateNewIndexName(index));
        }
    }

    protected void handleUnexpectedObject(DiffResult result, DatabaseObject obj) {
        result.addUnexpectedObject(obj);
    }

    protected String writeDiffResultToChangeLog(DiffResult result) throws Exception {
        DiffOutputControl diffOutputControl = this.newDiffOutputControl();
        DiffToChangeLog diffToChangeLog = new DiffToChangeLog(result, diffOutputControl);
        diffToChangeLog.setChangeSetAuthor(this.changeSetAuthor);
        String encoding = StandardCharsets.UTF_8.name();
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            PrintStream out = new PrintStream((OutputStream)bytesOut, true, encoding);
            try {
                diffToChangeLog.print(out);
                out.flush();
                String string = bytesOut.toString(encoding);
                out.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected DiffOutputControl newDiffOutputControl() {
        return new DiffOutputControl(false, false, false, null);
    }

    protected String generateNewPrimaryKeyName(PrimaryKey primaryKey) {
        return "pk_" + primaryKey.getTable().getName();
    }

    protected String generateNewForeignKeyName(ForeignKey foreignKey) {
        Table primaryKeyTable = foreignKey.getPrimaryKeyTable();
        Table foreignKeyTable = foreignKey.getForeignKeyTable();
        return "fk_" + foreignKeyTable.getName() + "_" + primaryKeyTable.getName();
    }

    protected String generateNewIndexName(Index index) {
        return index.getColumns().stream().map(Column::getName).collect(Collectors.joining("_", "idx_" + index.getRelation().getName() + "_", ""));
    }

    protected Database newDatabase(Connection connection) {
        AbstractJdbcDatabase database = this.createDatabase();
        database.setConnection((DatabaseConnection)new JdbcConnection(connection));
        return database;
    }

    protected abstract AbstractJdbcDatabase createDatabase();
}

