/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.liquibase.changelog.generator;

import de.cronn.liquibase.changelog.generator.AbstractHibernatePopulatedConfig;
import de.cronn.liquibase.changelog.generator.HibernateIntegratorForSchemaExport;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerHaltImpl;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class HibernateSchemaExport {
    private static final Logger log = LoggerFactory.getLogger(HibernateSchemaExport.class);
    private final Class<? extends AbstractHibernatePopulatedConfig> hibernatePopulatedConfigClass;

    public HibernateSchemaExport(Class<? extends AbstractHibernatePopulatedConfig> hibernatePopulatedConfigClass) {
        this.hibernatePopulatedConfigClass = hibernatePopulatedConfigClass;
    }

    public String export() {
        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{this.hibernatePopulatedConfigClass});){
            log.trace("Created application context {}", (Object)context);
            String schemaExport = this.exportSchema();
            String string = this.normalizeSchemaDumpFile(schemaExport);
            return string;
        }
    }

    protected String exportSchema() {
        Metadata metadata = HibernateIntegratorForSchemaExport.getMetadata();
        Map<String, Object> config = this.buildConfig();
        StringWriter writer = new StringWriter();
        SchemaCreator schemaCreator = this.getSchemaCreator(config);
        schemaCreator.doCreation(metadata, (ExecutionOptions)new ExecutionOptionsForSchemaExport(config), ContributableMatcher.ALL, (SourceDescriptor)new MetadataSourceDescriptor(), (TargetDescriptor)new ScriptTargetDescriptor(writer));
        return writer.toString();
    }

    protected String normalizeSchemaDumpFile(String schemaExport) {
        String schemaExportWithNormalizedWhitespaces = this.normalizeIndentations(schemaExport);
        return this.sortCreateTypeStatements(schemaExportWithNormalizedWhitespaces);
    }

    protected String normalizeIndentations(String schemaExport) {
        return Arrays.stream(schemaExport.split("\r?\n")).map(line -> {
            line = line.replaceFirst("^ {4}", "");
            line = line.replaceFirst("^ {3}(\\w)", "    $1");
            return StringUtils.stripEnd((String)line, null);
        }).collect(Collectors.joining("\n"));
    }

    protected String sortCreateTypeStatements(String schemaExport) {
        String partToSort = StringUtils.substringBefore((String)schemaExport, (String)"create table");
        String partAfterSort = schemaExport.substring(partToSort.length());
        String sortedPart = Stream.of(partToSort.split("create type")).sorted().collect(Collectors.joining("create type"));
        return sortedPart + partAfterSort;
    }

    protected Map<String, Object> buildConfig() {
        ConfigurationService configurationService = (ConfigurationService)this.getServiceRegistry().requireService(ConfigurationService.class);
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>(configurationService.getSettings());
        config.put("hibernate.format_sql", true);
        return config;
    }

    protected SchemaCreator getSchemaCreator(Map<String, Object> config) {
        return ((SchemaManagementTool)this.getServiceRegistry().requireService(SchemaManagementTool.class)).getSchemaCreator(config);
    }

    protected StandardServiceRegistry getServiceRegistry() {
        MetadataImplementor metadata = (MetadataImplementor)HibernateIntegratorForSchemaExport.getMetadata();
        return metadata.getMetadataBuildingOptions().getServiceRegistry();
    }

    private static class ExecutionOptionsForSchemaExport
    implements ExecutionOptions {
        private final Map<String, Object> config;

        public ExecutionOptionsForSchemaExport(Map<String, Object> config) {
            this.config = config;
        }

        public Map<String, Object> getConfigurationValues() {
            return this.config;
        }

        public boolean shouldManageNamespaces() {
            return false;
        }

        public ExceptionHandler getExceptionHandler() {
            return ExceptionHandlerHaltImpl.INSTANCE;
        }
    }

    private static class MetadataSourceDescriptor
    implements SourceDescriptor {
        private MetadataSourceDescriptor() {
        }

        public SourceType getSourceType() {
            return SourceType.METADATA;
        }

        public ScriptSourceInput getScriptSourceInput() {
            return null;
        }
    }

    private static class ScriptTargetDescriptor
    implements TargetDescriptor {
        private final Writer writer;

        public ScriptTargetDescriptor(Writer writer) {
            this.writer = writer;
        }

        public EnumSet<TargetType> getTargetTypes() {
            return EnumSet.of(TargetType.SCRIPT);
        }

        public ScriptTargetOutput getScriptTargetOutput() {
            return new ScriptTargetOutputToWriter(this.writer);
        }
    }
}

