/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.commons.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static <T> Collector<T, ?, Set<T>> toLinkedHashSet() {
        return Collectors.toCollection(LinkedHashSet::new);
    }

    public static <T> Collector<T, ?, List<T>> toModifiableList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return Collectors.groupingBy(classifier, LinkedHashMap::new, Collectors.toList());
    }

    public static <T, K> Collector<T, ?, Map<K, T>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper) {
        Function identity = Function.identity();
        return StreamUtil.toLinkedHashMap(keyMapper, identity);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return StreamUtil.toLinkedHashMap(keyMapper, valueMapper, (key, newValue, existingValue) -> {
            String message = "Duplicate key '%s' with values '%s' and '%s'".formatted(key, newValue, existingValue);
            return new IllegalArgumentException(message);
        });
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, DuplicateKeyExceptionSupplier<K, V> exceptionSupplier) {
        return new UniqueKeyLinkedHashMapCollector<T, K, V>(keyMapper, valueMapper, exceptionSupplier);
    }

    public static <T> Collector<T, ?, Optional<T>> toSingleOptionalElement() {
        return StreamUtil.toSingleOptionalElement(list -> new IllegalStateException("One or zero elements expected but got " + list.size() + ": " + String.valueOf(list)));
    }

    public static <T> Collector<T, ?, Optional<T>> toSingleOptionalElement(ExceptionSupplier<T> exceptionSupplier) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            int size = list.size();
            if (size > 1) {
                throw exceptionSupplier.get((List)list);
            }
            if (size == 1) {
                return Optional.of(list.get(0));
            }
            return Optional.empty();
        });
    }

    public static <T> Collector<T, ?, T> toSingleElement() {
        return StreamUtil.toSingleElement((ExceptionSupplier)null);
    }

    public static <T> Collector<T, ?, T> toSingleElement(Supplier<RuntimeException> exceptionSupplier) {
        return StreamUtil.toSingleElement((List<T> list) -> (RuntimeException)exceptionSupplier.get());
    }

    public static <T> Collector<T, ?, T> toSingleElement(ExceptionSupplier<T> exceptionSupplier) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            int size = list.size();
            if (size != 1) {
                if (exceptionSupplier != null) {
                    throw exceptionSupplier.get((List)list);
                }
                throw new IllegalStateException("Exactly one element expected but got " + size + ": " + String.valueOf(list));
            }
            return list.get(0);
        });
    }

    public static <T> boolean hasDuplicates(Stream<T> entries) {
        HashSet hashSet = new HashSet();
        return entries.anyMatch(e -> !hashSet.add(e));
    }

    @FunctionalInterface
    public static interface DuplicateKeyExceptionSupplier<K, V> {
        public RuntimeException get(K var1, V var2, V var3);
    }

    private static class UniqueKeyLinkedHashMapCollector<T, K, V>
    implements Collector<T, Map<K, V>, Map<K, V>> {
        private final Function<? super T, ? extends K> keyMapper;
        private final Function<? super T, ? extends V> valueMapper;
        private final DuplicateKeyExceptionSupplier<K, V> exceptionSupplier;

        UniqueKeyLinkedHashMapCollector(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, DuplicateKeyExceptionSupplier<K, V> exceptionSupplier) {
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
            this.exceptionSupplier = exceptionSupplier;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
        }

        @Override
        public BiConsumer<Map<K, V>, T> accumulator() {
            return (map, element) -> {
                K key = this.keyMapper.apply(element);
                V value = this.valueMapper.apply(element);
                this.accumulate((Map<K, V>)map, key, value);
            };
        }

        @Override
        public Supplier<Map<K, V>> supplier() {
            return LinkedHashMap::new;
        }

        @Override
        public BinaryOperator<Map<K, V>> combiner() {
            return (m1, m2) -> {
                for (Map.Entry e : m2.entrySet()) {
                    this.accumulate((Map<K, V>)m1, e.getKey(), e.getValue());
                }
                return m1;
            };
        }

        @Override
        public Function<Map<K, V>, Map<K, V>> finisher() {
            return Function.identity();
        }

        private void accumulate(Map<K, V> map, K key, V value) {
            V existing = map.putIfAbsent(key, value);
            if (existing != null) {
                throw this.exceptionSupplier.get(key, value, existing);
            }
        }
    }

    @FunctionalInterface
    public static interface ExceptionSupplier<T> {
        public RuntimeException get(List<T> var1);
    }
}

