/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.commons.lang;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public final class AlphanumericComparator
implements Comparator<String> {
    private static final int MAX_LONG_STRING_SIZE = Long.toString(Long.MAX_VALUE).length();
    private static final AlphanumericComparator INSTANCE = new AlphanumericComparator();
    private final Collator collator = Collator.getInstance(Locale.ROOT);

    private AlphanumericComparator() {
    }

    public static AlphanumericComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(String s1, String s2) {
        String s2Slice;
        String s1Slice;
        if (AlphanumericComparator.isNullOrBlank(s1)) {
            return AlphanumericComparator.isNullOrBlank(s2) ? 0 : -1;
        }
        if (AlphanumericComparator.isNullOrBlank(s2)) {
            return 1;
        }
        s1 = s1.trim();
        s2 = s2.trim();
        int s1Index = 0;
        for (int s2Index = 0; s1Index < s1.length() && s2Index < s2.length(); s1Index += s1Slice.length(), s2Index += s2Slice.length()) {
            s1Slice = this.slice(s1, s1Index);
            s2Slice = this.slice(s2, s2Index);
            int result = this.compareSlices(s1Slice, s2Slice);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(s1.length(), s2.length());
    }

    private static boolean isNullOrBlank(String string) {
        return string == null || string.isBlank();
    }

    private int compareSlices(String s1, String s2) {
        if (Character.isDigit(s1.charAt(0)) && Character.isDigit(s2.charAt(0))) {
            return this.compareDigits(s1, s2);
        }
        return this.compareCollatedStrings(s1, s2);
    }

    private String slice(String s, int index) {
        if (Character.isDigit(s.charAt(index))) {
            StringBuilder result = new StringBuilder();
            while (index < s.length() && Character.isDigit(s.charAt(index))) {
                result.append(s.charAt(index));
                ++index;
            }
            return result.toString();
        }
        return s.substring(index, index + 1);
    }

    private int compareDigits(String s1, String s2) {
        if (s1.length() < MAX_LONG_STRING_SIZE && s2.length() < MAX_LONG_STRING_SIZE) {
            return Long.compare(Long.parseLong(s1), Long.parseLong(s2));
        }
        return new BigDecimal(s1).compareTo(new BigDecimal(s2));
    }

    private int compareCollatedStrings(String s1, String s2) {
        return this.collator.compare(s1, s2);
    }

    public static boolean isBefore(String string, String stringToCompareWith) {
        return AlphanumericComparator.getInstance().compare(string, stringToCompareWith) < 0;
    }

    public static boolean isAfterOrEqual(String string, String stringToCompareWith) {
        return !AlphanumericComparator.isBefore(string, stringToCompareWith);
    }

    public static boolean isAfter(String string, String stringToCompareWith) {
        return AlphanumericComparator.getInstance().compare(string, stringToCompareWith) > 0;
    }
}

