/*
 * Decompiled with CFR 0.152.
 */
package de.cronn.camunda.testserver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.rest.impl.CamundaRestResources;
import org.camunda.bpm.engine.rest.impl.FetchAndLockContextListener;
import org.camunda.spin.plugin.impl.SpinProcessEnginePlugin;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class EmbeddedCamundaRestServer {
    private final List<String> bpmnClasspathFilesToDeploy;
    private final int port;
    private Server server;
    private ProcessEngine processEngine;
    final String inMemoryH2DatabaseUrl = "jdbc:h2:mem:" + EmbeddedCamundaRestServer.class.getSimpleName() + "_" + UUID.randomUUID() + ";DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=false";

    public EmbeddedCamundaRestServer(int port, String ... bpmnClasspathFilesToDeploy) {
        this.bpmnClasspathFilesToDeploy = Arrays.asList(bpmnClasspathFilesToDeploy);
        this.port = port;
    }

    public void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("Server already running");
        }
        this.processEngine = this.createProcessEngine();
        this.deployBpmnClasspathFiles((String[])this.bpmnClasspathFilesToDeploy.toArray(String[]::new));
        this.startHttpServerWithCamundaRestApplication();
    }

    private void startHttpServerWithCamundaRestApplication() throws Exception {
        this.server = new Server(this.port);
        this.server.setHandler((Handler)this.createServletContextWithCamundaRestApplication());
        this.server.start();
    }

    private ServletContextHandler createServletContextWithCamundaRestApplication() {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addEventListener((EventListener)new FetchAndLockContextListener());
        CXFNonSpringJaxrsServlet servlet = new CXFNonSpringJaxrsServlet();
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setInitParameter("jaxrs.serviceClasses", EmbeddedCamundaRestServer.toString(CamundaRestResources.getResourceClasses()));
        servletHolder.setInitParameter("jaxrs.providers", EmbeddedCamundaRestServer.toString(CamundaRestResources.getConfigurationClasses()));
        servletHolder.setInitParameter("jaxrs.address", "/engine-rest");
        context.addServlet(servletHolder, "/*");
        return context;
    }

    private ProcessEngine createProcessEngine() {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEnginePlugins(Arrays.asList(new SpinProcessEnginePlugin()));
        return processEngineConfiguration.setJdbcUrl(this.inMemoryH2DatabaseUrl).setJobExecutorActivate(true).buildProcessEngine();
    }

    public void deployBpmnClasspathFiles(String ... bpmnClasspathFilesToDeploy) {
        if (bpmnClasspathFilesToDeploy.length > 0) {
            DeploymentBuilder deployment = this.processEngine.getRepositoryService().createDeployment();
            for (String bpmnClasspathFileToDeploy : bpmnClasspathFilesToDeploy) {
                deployment.addClasspathResource(bpmnClasspathFileToDeploy);
            }
            deployment.deploy();
        }
    }

    private static String toString(Collection<Class<?>> classes) {
        return classes.stream().map(Class::getName).collect(Collectors.joining(","));
    }

    public int getPort() {
        if (this.server != null && this.server.isRunning()) {
            return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        return this.port;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void stop() throws Exception {
        this.stopHttpServer();
        this.processEngine.close();
        this.shutdownDatabase();
        this.server = null;
        this.processEngine = null;
    }

    private void stopHttpServer() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running");
        }
        this.server.stop();
        this.server.join();
    }

    private void shutdownDatabase() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.inMemoryH2DatabaseUrl, "sa", "");
             Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN");
        }
    }
}

