/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.util;

import io.github.slimjar.libs.annotations.NotNull;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Serialization {
    private Serialization() {
    }

    public static void writeURL(@NotNull URL url, @NotNull DataOutput out) throws IOException {
        out.writeUTF(url.toExternalForm());
    }

    public static <T> void writeList(@NotNull @NotNull Collection<@NotNull T> list, @NotNull DataOutput out, @NotNull @NotNull Serializer<@NotNull T> writer) throws IOException {
        int size = list.size();
        Serialization.writeSignedVarInt(size, out);
        for (T value : list) {
            writer.invoke(value, out);
        }
    }

    public static void writeSignedVarInt(int value, @NotNull DataOutput out) throws IOException {
        value = value << 1 ^ value >> 31;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value & 0x7F);
    }

    public static URL readURL(@NotNull DataInput in) throws IOException {
        return URI.create(in.readUTF()).toURL();
    }

    public static <T> List<T> readList(@NotNull DataInput in, @NotNull @NotNull Deserializer<@NotNull T> deserializer) throws IOException {
        int size = Serialization.readSignedVarInt(in);
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            list.add(deserializer.invoke(in));
        }
        return list;
    }

    public static int readSignedVarInt(DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i2 = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i2;
            if ((i2 += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        int raw = value | b << i2;
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    @FunctionalInterface
    public static interface Serializer<T> {
        public void invoke(@NotNull T var1, @NotNull DataOutput var2) throws IOException;
    }

    @FunctionalInterface
    public static interface Deserializer<T> {
        public T invoke(@NotNull DataInput var1) throws IOException;
    }
}

