/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.util;

import io.github.slimjar.app.module.ModuleExtractor;
import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.NotNull;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Modules {
    private Modules() {
    }

    @NotNull
    public static URL findModule(@NotNull String moduleName) {
        ClassLoader classLoader = Modules.class.getClassLoader();
        return Objects.requireNonNull(classLoader.getResource(moduleName + ".isolated-jar"));
    }

    @NotNull
    public static URL[] extract(@NotNull ModuleExtractor extractor, @NotNull Collection<String> modules) {
        URL[] urls = new URL[modules.size()];
        int index = 0;
        for (String moduleName : modules) {
            URL modulePath = Modules.findModule(moduleName);
            URL extractedModule = extractor.extractModule(modulePath, moduleName);
            urls[index++] = extractedModule;
        }
        return urls;
    }

    @NotNull
    public static Set<String> findLocalModules() throws ResolutionException {
        Set<String> set;
        block10: {
            Path resourcesPath;
            URL url = Modules.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                resourcesPath = Paths.get(url.toURI());
            }
            catch (URISyntaxException err) {
                throw new ResolutionException("Failed to resolve local modules", err);
            }
            Stream<Path> stream = Files.walk(resourcesPath, 1, new FileVisitOption[0]);
            try {
                set = stream.filter(path -> path.endsWith(".isolated-jar")).map(path -> path.getFileName().toString()).collect(Collectors.toUnmodifiableSet());
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException err) {
                    throw new ResolutionException("Encountered exception while walking files.", err);
                }
            }
            stream.close();
        }
        return set;
    }
}

