/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.strategy;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.strategy.PathResolutionStrategy;
import java.util.Collection;

public final class MediatingPathResolutionStrategy
implements PathResolutionStrategy {
    @NotNull
    private final PathResolutionStrategy releaseStrategy;
    @NotNull
    private final PathResolutionStrategy snapshotStrategy;

    @Contract(pure=true)
    public MediatingPathResolutionStrategy(@NotNull PathResolutionStrategy releaseStrategy, @NotNull PathResolutionStrategy snapshotStrategy) {
        this.releaseStrategy = releaseStrategy;
        this.snapshotStrategy = snapshotStrategy;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull Collection<@NotNull String> pathTo(@NotNull Repository repository, @NotNull Dependency dependency) {
        if (dependency.snapshotId() != null) {
            return this.snapshotStrategy.pathTo(repository, dependency);
        }
        return this.releaseStrategy.pathTo(repository, dependency);
    }
}

